<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-plus me-2"></i>
            <?php if($parentQuestion): ?>
                เพิ่มคำถามย่อย
            <?php else: ?>
                เพิ่มคำถามใหม่
            <?php endif; ?>
        </h1>
        <a href="<?php echo e(route('admin.question-groups.edit', $group)); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i>
            กลับไปกลุ่มคำถาม
        </a>
    </div>

    <!-- แสดงข้อมูลคำถามแม่ (ถ้ามี) -->
    <?php if($parentQuestion): ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3 bg-info text-white">
                <h6 class="m-0 font-weight-bold">
                    <i class="fas fa-info-circle me-2"></i>
                    คำถามแม่
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <h6 class="text-primary"><?php echo e($parentQuestion->question_text); ?></h6>
                        <?php if($parentQuestion->description): ?>
                            <p class="text-muted mb-2"><?php echo e($parentQuestion->description); ?></p>
                        <?php endif; ?>
                        <div class="d-flex gap-2">
                            <span class="badge bg-primary"><?php echo e($parentQuestion->question_type_label); ?></span>
                            <?php if($parentQuestion->use_in_evaluation): ?>
                                <span class="badge bg-success">ใช้ในการประเมิน</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">ไม่ใช้ในการประเมิน</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-4 text-end">
                        <small class="text-muted">
                            <i class="fas fa-calendar me-1"></i>
                            <?php echo e($parentQuestion->DtmIns->format('d/m/Y H:i')); ?>

                        </small>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Create Question Form -->
    <div class="card shadow">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-question-circle me-2"></i>
                <?php if($parentQuestion): ?>
                    ข้อมูลคำถามย่อย - <?php echo e($group->name); ?>

                <?php else: ?>
                    ข้อมูลคำถาม - <?php echo e($group->name); ?>

                <?php endif; ?>
            </h6>
        </div>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('admin.questions.store', $group)); ?>">
                <?php echo csrf_field(); ?>
                
                <!-- Hidden input สำหรับ parent_id -->
                <?php if($parentQuestion): ?>
                    <input type="hidden" name="parent_id" value="<?php echo e($parentQuestion->id); ?>">
                <?php endif; ?>
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label for="question_text" class="form-label">คำถาม <span class="text-danger">*</span></label>
                            <textarea class="form-control <?php $__errorArgs = ['question_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="question_text" 
                                      name="question_text" 
                                      rows="3" 
                                      placeholder="กรอกคำถาม เช่น: 4.2.1.1 วิธีการติดตั้ง หมายรวมถึง"
                                      required><?php echo e(old('question_text')); ?></textarea>
                            <?php $__errorArgs = ['question_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            
                            <!-- Live Preview สำหรับเลขข้อ -->
                            <div id="question-preview" class="mt-2" style="display: none;">
                                <div class="card border-info">
                                    <div class="card-header bg-info text-white py-2">
                                        <small><i class="fas fa-eye me-1"></i>ตัวอย่างการแสดงผล</small>
                                    </div>
                                    <div class="card-body py-2">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <strong>เลขข้อ:</strong>
                                                <div id="preview-number" class="text-primary"></div>
                                            </div>
                                            <div class="col-md-9">
                                                <strong>ข้อกำหนด:</strong>
                                                <div id="preview-content" class="text-dark"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">คำอธิบายเพิ่มเติม</label>
                            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="description" 
                                      name="description" 
                                      rows="3" 
                                      placeholder="กรอกคำอธิบายเพิ่มเติม (ถ้ามี)"><?php echo e(old('description')); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="question_type" class="form-label">ประเภทคำตอบ <span class="text-danger">*</span></label>
                                    <select class="form-select <?php $__errorArgs = ['question_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="question_type" 
                                            name="question_type" 
                                            >
                                        <option value="yes_no" <?php echo e(old('question_type') == 'yes_no' ? 'selected' : ''); ?>>ใช่/ไม่ใช่ (Yes/No)</option>
                                        <option value="multiple_choice" <?php echo e(old('question_type') == 'multiple_choice' ? 'selected' : ''); ?>>ตัวเลือก (Multiple Choice)</option>
                                        <option value="text" <?php echo e(old('question_type') == 'text' ? 'selected' : ''); ?>>ข้อความ (Text)</option>
                                        <option value="" <?php echo e(old('question_type', '') === '' ? 'selected' : ''); ?> selected>ไม่มี</option>
                                    </select>
                                    <?php $__errorArgs = ['question_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">เลือกประเภทคำตอบที่ต้องการ</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="use_in_evaluation" class="form-label">ใช้ในการประเมิน</label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" 
                                               id="use_in_evaluation" 
                                               name="use_in_evaluation" 
                                               value="1" 
                                               <?php echo e(old('use_in_evaluation') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="use_in_evaluation">
                                            ใช้คำถามนี้ในการประเมินผล
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">คำถามนี้จะถูกนำมาคำนวณผลการประเมิน</small>
                                </div>
                            </div>
                        </div>

                        <!-- Choice Options for Multiple Choice Questions -->
                        <div id="choice_options_container" class="mb-3" style="display: none;">
                            <label class="form-label">ตัวเลือก <span class="text-danger">*</span></label>
                            <div id="choices_container">
                                <div class="choice-item mb-2">
                                    <div class="input-group">
                                        <input type="text" 
                                               class="form-control choice-input" 
                                               name="choices[]" 
                                               placeholder="กรอกตัวเลือกที่ 1">
                                        <button type="button" class="btn btn-outline-danger remove-choice-btn">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="choice-item mb-2">
                                    <div class="input-group">
                                        <input type="text" 
                                               class="form-control choice-input" 
                                               name="choices[]" 
                                               placeholder="กรอกตัวเลือกที่ 2">
                                        <button type="button" class="btn btn-outline-danger remove-choice-btn">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-choice-btn">
                                <i class="fas fa-plus me-1"></i>
                                เพิ่มตัวเลือก
                            </button>
                            <small class="form-text text-muted">กรอกตัวเลือกสำหรับคำถามแบบตัวเลือก</small>
                        </div>
                    </div>
                    
                    <div class="alert alert-info col-md-4">
                        <i class="fas fa-info-circle me-1"></i>
                        <strong>หมายเหตุ:</strong>
                        <ul class="mb-0 mt-2">
                            <li>ใช้การลากในหน้าแก้ไขกลุ่มคำถามเพื่อกำหนดความสัมพันธ์แม่-ลูก</li>
                            <li>เงื่อนไขการเชื่อมต่อ (AND/OR) จะแสดงในหน้าแก้ไขกลุ่มคำถาม</li>
                            <li>สำหรับคำถามที่ต้องการให้มีคำถามย่อย ให้เลือกประเภทคำตอบเป็น "ไม่มี" </li>
                        </ul>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <a href="<?php echo e(route('admin.question-groups.edit', $group)); ?>" class="btn btn-secondary">
                        <i class="fas fa-times me-1"></i>
                        ยกเลิก
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>
                        บันทึกคำถาม
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const questionTypeSelect = document.getElementById('question_type');
    const choiceOptionsContainer = document.getElementById('choice_options_container');
    const addChoiceBtn = document.getElementById('add-choice-btn');
    const choicesContainer = document.getElementById('choices_container');
    const questionTextArea = document.getElementById('question_text');
    const questionPreview = document.getElementById('question-preview');
    const previewNumber = document.getElementById('preview-number');
    const previewContent = document.getElementById('preview-content');
    const useInEvaluationCheckbox = document.getElementById('use_in_evaluation');

    // Show/hide choice options based on question type
    questionTypeSelect.addEventListener('change', function() {
        const selectedType = this.value;
        const choiceInputs = document.querySelectorAll('.choice-input');
        
        if (selectedType === 'multiple_choice') {
            choiceOptionsContainer.style.display = 'block';
            // multiple_choice ไม่ใช้ในการประเมินเสมอ
            useInEvaluationCheckbox.checked = false;
            useInEvaluationCheckbox.disabled = true;
            // เพิ่ม hidden input เพื่อส่งค่า 0
            addHiddenInput('use_in_evaluation', '0');
            // เพิ่ม required ให้ choice inputs
            choiceInputs.forEach(input => {
                input.required = true;
            });
        } else if (selectedType === 'text') {
            choiceOptionsContainer.style.display = 'none';
            // text ไม่ใช้ในการประเมินเสมอ
            useInEvaluationCheckbox.checked = false;
            useInEvaluationCheckbox.disabled = true;
            // เพิ่ม hidden input เพื่อส่งค่า 0
            addHiddenInput('use_in_evaluation', '0');
            // ลบ required จาก choice inputs
            choiceInputs.forEach(input => {
                input.required = false;
            });
        } else if (selectedType === 'yes_no') {
            choiceOptionsContainer.style.display = 'none';
            // yes_no สามารถเลือกใช้ในการประเมินได้
            useInEvaluationCheckbox.disabled = false;
            // ลบ hidden input ถ้ามี
            removeHiddenInput('use_in_evaluation');
            // ลบ required จาก choice inputs
            choiceInputs.forEach(input => {
                input.required = false;
            });
        } else if (selectedType === '') { // เลือก "ไม่มี"
            choiceOptionsContainer.style.display = 'none';
            // "ไม่มี" สามารถเลือกใช้ในการประเมินได้
            useInEvaluationCheckbox.disabled = false;
            // ลบ hidden input ถ้ามี
            removeHiddenInput('use_in_evaluation');
            // ลบ required จาก choice inputs
            choiceInputs.forEach(input => {
                input.required = false;
            });
        }
    });

    // Add new choice option
    function addChoice() {
        const choiceDiv = document.createElement('div');
        choiceDiv.className = 'input-group mb-2';
        choiceDiv.innerHTML = `
            <input type="text" class="form-control choice-input" 
                   name="choices[]" 
                   placeholder="ตัวเลือก" 
                   required>
            <button type="button" class="btn btn-outline-danger" onclick="removeChoice(this)">
                <i class="fas fa-times"></i>
            </button>
        `;
        choicesContainer.appendChild(choiceDiv);
    }

    // Remove choice option
    function removeChoice(button) {
        button.parentElement.remove();
    }

    // Add hidden input function
    function addHiddenInput(name, value) {
        // ลบ hidden input เดิมถ้ามี
        removeHiddenInput(name);
        
        const hiddenInput = document.createElement('input');
        hiddenInput.type = 'hidden';
        hiddenInput.name = name;
        hiddenInput.value = value;
        document.querySelector('form').appendChild(hiddenInput);
    }

    // Remove hidden input function
    function removeHiddenInput(name) {
        const existingInput = document.querySelector(`input[name="${name}"][type="hidden"]`);
        if (existingInput) {
            existingInput.remove();
        }
    }

    // Update choice numbers
    function updateChoiceNumbers() {
        const choiceItems = document.querySelectorAll('.choice-item');
        choiceItems.forEach((item, index) => {
            const numberSpan = item.querySelector('.input-group-text');
            if (numberSpan) {
                numberSpan.textContent = index + 1;
            }
        });
    }

    // Update remove buttons
    function updateRemoveButtons() {
        const choiceItems = document.querySelectorAll('.choice-item');
        const removeButtons = document.querySelectorAll('.remove-choice-btn');
        
        choiceItems.forEach((item, index) => {
            const removeBtn = item.querySelector('.remove-choice-btn');
            if (removeBtn) {
                removeBtn.style.display = choiceItems.length > 1 ? 'block' : 'none';
            }
        });
    }

    // Initialize form state based on current question type
    function initializeFormState() {
        const selectedType = questionTypeSelect.value;
        if (selectedType === 'multiple_choice') {
            choiceOptionsContainer.style.display = 'block';
            useInEvaluationCheckbox.checked = false;
            useInEvaluationCheckbox.disabled = true;
            addHiddenInput('use_in_evaluation', '0');
        } else if (selectedType === 'text') {
            choiceOptionsContainer.style.display = 'none';
            useInEvaluationCheckbox.checked = false;
            useInEvaluationCheckbox.disabled = true;
            addHiddenInput('use_in_evaluation', '0');
        } else if (selectedType === 'yes_no') {
            choiceOptionsContainer.style.display = 'none';
            useInEvaluationCheckbox.disabled = false;
            removeHiddenInput('use_in_evaluation');
        } else if (selectedType === '') {
            choiceOptionsContainer.style.display = 'none';
            useInEvaluationCheckbox.disabled = false;
            removeHiddenInput('use_in_evaluation');
        }
    }

    // Initialize form state when page loads
    initializeFormState();

    // Live preview for question text
    questionTextArea.addEventListener('input', function() {
        const text = this.value;
        let previewNumberText = '';
        let previewContentText = '';

        // Extract number and content - รองรับรูปแบบ: 1.2, 1.2.3, 1.2.3.4, 1.2.3.4.5, etc.
        const numberMatch = text.match(/^(\d+(?:\.\d+)*)\s*(.+)$/);
        if (numberMatch) {
            previewNumberText = numberMatch[1]; // แสดงเฉพาะเลขข้อ ไม่มีคำว่า "ข้อ"
            previewContentText = numberMatch[2];
        } else {
            previewNumberText = '';
            previewContentText = text;
        }

        previewNumber.textContent = previewNumberText;
        previewContent.textContent = previewContentText;

        if (previewNumberText || previewContentText) {
            questionPreview.style.display = 'block';
        } else {
            questionPreview.style.display = 'none';
        }
    });

    // Event listeners
    addChoiceBtn.addEventListener('click', addChoice);
    
    // Event delegation for remove buttons
    choicesContainer.addEventListener('click', function(e) {
        if (e.target.closest('.remove-choice-btn')) {
            removeChoice(e.target.closest('.remove-choice-btn'));
        }
    });
});
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel-project\resources\views/admin/questions/create.blade.php ENDPATH**/ ?>