<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-edit me-2"></i>
            แก้ไขผลิตภัณฑ์: <?php echo e($product->name); ?>

        </h1>
        <a href="<?php echo e(route('admin.products')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i>
            กลับไปรายการผลิตภัณฑ์
        </a>
    </div>

    <!-- Edit Product Form -->
    <div class="card shadow">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-box me-2"></i>
                ข้อมูลผลิตภัณฑ์
            </h6>
        </div>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('admin.products.update', $product)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label for="name" class="form-label">ชื่อผลิตภัณฑ์ <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="name" 
                                   name="name" 
                                   value="<?php echo e(old('name', $product->name)); ?>" 
                                   placeholder="กรอกชื่อผลิตภัณฑ์"
                                   required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="model" class="form-label">โมเดล/รุ่น</label>
                            <input type="text" 
                                   class="form-control <?php $__errorArgs = ['model'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="model" 
                                   name="model" 
                                   value="<?php echo e(old('model', $product->model)); ?>" 
                                   placeholder="กรอกโมเดล/รุ่น (ถ้ามี)">
                            <?php $__errorArgs = ['model'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="log_receive_method" class="form-label">วิธีรับข้อมูล <span class="text-danger">*</span></label>
                                    <select class="form-select <?php $__errorArgs = ['log_receive_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="log_receive_method" 
                                            name="log_receive_method" 
                                            required>
                                        <option value="">เลือกวิธีรับข้อมูล</option>
                                        <option value="syslog_udp" <?php echo e(old('log_receive_method', $product->log_receive_method) == 'syslog_udp' ? 'selected' : ''); ?>>
                                            Syslog UDP
                                        </option>
                                        <option value="syslog_tcp" <?php echo e(old('log_receive_method', $product->log_receive_method) == 'syslog_tcp' ? 'selected' : ''); ?>>
                                            Syslog TCP
                                        </option>
                                        <option value="syslog_both" <?php echo e(old('log_receive_method', $product->log_receive_method) == 'syslog_both' ? 'selected' : ''); ?>>
                                            Syslog ทั้ง UDP และ TCP
                                        </option>
                                        <option value="other" <?php echo e(old('log_receive_method', $product->log_receive_method) == 'other' ? 'selected' : ''); ?>>
                                            อื่นๆ
                                        </option>
                                    </select>
                                    <?php $__errorArgs = ['log_receive_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="product_type" class="form-label">ประเภทผลิตภัณฑ์ <span class="text-danger">*</span></label>
                                    <select class="form-select <?php $__errorArgs = ['product_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="product_type" 
                                            name="product_type" 
                                            required>
                                        <option value="">เลือกประเภทผลิตภัณฑ์</option>
                                        <option value="hw_sw_log_server" <?php echo e(old('product_type', $product->product_type) == 'hw_sw_log_server' ? 'selected' : ''); ?>>
                                            Hardware + Software Log Server
                                        </option>
                                        <option value="sw_log_server" <?php echo e(old('product_type', $product->product_type) == 'sw_log_server' ? 'selected' : ''); ?>>
                                            Software Log Server
                                        </option>
                                    </select>
                                    <?php $__errorArgs = ['product_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">คำอธิบาย</label>
                            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="description" 
                                      name="description" 
                                      rows="4" 
                                      placeholder="กรอกคำอธิบายเพิ่มเติม (ถ้ามี)"><?php echo e(old('description', $product->description)); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="image" class="form-label">รูปภาพผลิตภัณฑ์</label>
                            <input type="file" 
                                   class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="image" 
                                   name="image" 
                                   accept="image/*">
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="form-text text-muted">
                                รองรับไฟล์: JPEG, PNG, JPG, GIF, SVG ขนาดไม่เกิน 2MB
                            </small>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-header">
                                <h6 class="mb-0">
                                    <i class="fas fa-info-circle me-1"></i>
                                    ข้อมูลเพิ่มเติม
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="fas fa-user me-1"></i>
                                        ผู้สร้าง: <?php echo e($product->user ? $product->user->Customer_Name : 'ไม่ระบุ'); ?>

                                    </small>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="fas fa-calendar me-1"></i>
                                        สร้างเมื่อ: <?php echo e($product->DtmIns ? $product->DtmIns->format('d/m/Y H:i') : 'ไม่ระบุ'); ?>

                                    </small>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="fas fa-edit me-1"></i>
                                        แก้ไขล่าสุด: <?php echo e($product->DtmUpd ? $product->DtmUpd->format('d/m/Y H:i') : 'ไม่ระบุ'); ?>

                                    </small>
                                </div>
                                <div class="mb-0">
                                    <small class="text-muted">
                                        <i class="fas fa-building me-1"></i>
                                        บริษัท: <?php echo e($product->user && $product->user->agency ? $product->user->agency->Agency_Name : 'ไม่ระบุ'); ?>

                                    </small>
                                </div>
                            </div>
                        </div>

                        <!-- รูปภาพปัจจุบัน -->
                        <?php if($product->image): ?>
                            <div class="card mt-3">
                                <div class="card-header">
                                    <h6 class="mb-0">
                                        <i class="fas fa-image me-1"></i>
                                        รูปภาพปัจจุบัน
                                    </h6>
                                </div>
                                <div class="card-body text-center">
                                    <img src="<?php echo e(asset('storage/' . $product->image)); ?>" 
                                         alt="รูปภาพผลิตภัณฑ์" 
                                         class="img-fluid rounded" 
                                         style="max-height: 200px;">
                                    <div class="mt-2">
                                        <small class="text-muted">
                                            รูปภาพนี้จะถูกแทนที่เมื่ออัปโหลดรูปใหม่
                                        </small>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <a href="<?php echo e(route('admin.products')); ?>" class="btn btn-secondary">
                        <i class="fas fa-times me-1"></i>
                        ยกเลิก
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>
                        บันทึกการเปลี่ยนแปลง
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Preview รูปภาพที่เลือก
    const imageInput = document.getElementById('image');
    const currentImage = document.querySelector('.card img');
    
    imageInput.addEventListener('change', function() {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                if (currentImage) {
                    currentImage.src = e.target.result;
                }
            };
            reader.readAsDataURL(file);
        }
    });
});
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel-project\resources\views/admin/products/edit.blade.php ENDPATH**/ ?>