<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- D3.js v7 (เวอร์ชันล่าสุด) -->
    <script src="https://d3js.org/d3.v7.min.js"></script>

    <title><?php echo e(config('app.name', 'Laravel')); ?> - Admin</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Custom CSS for Admin Navigation -->
    <style>
        /* บังคับให้แสดงเมนูใน desktop */
        @media (min-width: 992px) {
            .navbar-collapse {
                display: flex !important;
                flex-basis: auto;
            }
            
            .navbar-nav {
                flex-direction: row !important;
            }
        }
        
        /* แก้ไขปัญหา hamburger menu */
        @media (max-width: 991.98px) {
            .navbar-collapse {
                background: white;
                border: 1px solid #dee2e6;
                border-top: none;
                box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            }
        }
        
        /* แก้ไขปัญหา CSS ที่ขัดแย้ง */
        .navbar-nav {
            display: flex !important;
        }
        
        .navbar-collapse {
            flex-grow: 1;
        }
    </style>
</head>
<body>
    <div class=" bg-light"></div>
        <!-- Navigation -->
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
            <div class="container">
                <a class="navbar-brand" href="<?php echo e(route('products.index')); ?>">
                    <img src="<?php echo e(asset('images/logo.jpg')); ?>" alt="Logo" style="width: 150px; height: 55px; margin: 5px;">
                </a>

                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">
                                <i class="fas fa-tachometer-alt me-1"></i>
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('admin.users')); ?>">
                                <i class="fas fa-users me-1"></i>
                                ผู้ใช้
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('admin.products')); ?>">
                                <i class="fas fa-boxes me-1"></i>
                                ผลิตภัณฑ์
                            </a>
                        </li>
                        
                        <li class="nav-item ">
                            <a class="nav-link ml-3" href="<?php echo e(route('admin.question-groups')); ?>">
                                <i class="fas fa-question-circle me-1"></i>
                                จัดการคำถาม
                            </a>
                        </li>
                        
                        
                    </ul>
                    
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('products.index')); ?>">
                                <img src="<?php echo e(asset('images/Profile.png')); ?>" alt="Profile" class="rounded-circle"  style="width: 32px; height: 32px; object-fit: cover;">
                                <?php echo e(Auth::user()->Customer_Name); ?>

                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>

        <!-- Page Content -->
        <main class="py-4">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\laravel-project\resources\views/layouts/admin.blade.php ENDPATH**/ ?>