# อัปเดตฟีเจอร์: แบบประเมินคู่มือ

## สิ่งที่เพิ่มเข้ามา

### 1. หน้าแบบประเมินคู่มือใหม่
- **ไฟล์**: `resources/views/assessments/manual.blade.php`
- **Route**: `GET /assessments/{assessment}/manual`
- **Controller Method**: `AssessmentController@manual`

### 2. ฟีเจอร์หลัก
- แสดงคำตอบที่มีอยู่แล้วจาก draft
- Progress bar แสดงความคืบหน้า
- ปุ่มบันทึกฉบับร่างและส่งแบบประเมิน
- ตรวจสอบสิทธิ์การเข้าถึง
- แสดงข้อมูลผลิตภัณฑ์

### 3. การเปลี่ยนแปลงในปุ่ม "ทำต่อ"
- **ไฟล์**: `resources/views/products/index.blade.php`
- เปลี่ยนจาก `route('assessments.edit')` เป็น `route('assessments.manual')`

## วิธีการทำงาน

1. **เมื่อผู้ใช้กดปุ่ม "ทำต่อ"**:
   - ระบบจะตรวจสอบว่า assessment นั้นเป็น draft หรือไม่
   - ถ้าเป็น draft จะพาไปหน้าแบบประเมินคู่มือ
   - ถ้าไม่ใช่ draft จะแสดงข้อความ error

2. **ในหน้าแบบประเมินคู่มือ**:
   - แสดงคำตอบที่มีอยู่แล้วจาก draft
   - ผู้ใช้สามารถแก้ไขคำตอบได้
   - มี progress bar แสดงความคืบหน้า
   - สามารถบันทึกเป็น draft หรือส่งแบบประเมินได้

3. **การตรวจสอบสิทธิ์**:
   - เฉพาะเจ้าของ assessment หรือ admin เท่านั้นที่เข้าถึงได้
   - ตรวจสอบสถานะ draft เท่านั้น

## ไฟล์ที่แก้ไข/เพิ่ม

### ไฟล์ใหม่
- `resources/views/assessments/manual.blade.php`

### ไฟล์ที่แก้ไข
- `routes/web.php` - เพิ่ม route ใหม่
- `app/Http/Controllers/AssessmentController.php` - เพิ่ม method manual
- `resources/views/products/index.blade.php` - แก้ไขปุ่ม "ทำต่อ"

## การทดสอบ

1. สร้างผลิตภัณฑ์ใหม่
2. เริ่มการประเมินและบันทึกเป็น draft
3. กลับไปหน้า index และกดปุ่ม "ทำต่อ"
4. ตรวจสอบว่าคำตอบที่มีอยู่แล้วแสดงขึ้นมา
5. ทดสอบการบันทึก draft และส่งแบบประเมิน 