# ฟีเจอร์ "ดูแผนผังโครงสร้างคำถาม"

## ภาพรวม
ฟีเจอร์นี้ช่วยให้ผู้ดูแลระบบสามารถดูโครงสร้างคำถามในรูปแบบแผนผังแบบ static ได้ ซึ่งจะแสดงความสัมพันธ์ระหว่างคำถามแม่และคำถามย่อย พร้อมกับ logic operator (AND/OR) ที่ใช้ในการประเมิน

## ฟีเจอร์หลัก

### 1. การแสดงผลแบบแผนผัง
- แสดงโครงสร้างคำถามในรูปแบบ hierarchical diagram
- แยกประเภทโหนดด้วยสีและไอคอน:
  - 🟢 **วงกลมทึบ** = AND node (โหนดที่มีโหนดย่อย สามารถขยาย/ยุบได้)
  - 🔵 **สี่เหลี่ยมทึบ** = OR node (โหนดที่มีโหนดย่อย สามารถขยาย/ยุบได้)
  - ⚪ **วงกลมโปร่ง** = Leaf node (โหนดที่ไม่มีโหนดย่อย ไม่สามารถขยาย/ยุบได้)

### 2. การแสดงผลแบบ Static
- **แสดงโครงสร้างทั้งหมด**: แสดงคำถามทั้งหมดพร้อมความสัมพันธ์
- **ความสัมพันธ์แบบ parent-child**: แสดงด้วยเส้นเชื่อม
- **Logic operator**: แสดงเงื่อนไขการเชื่อมต่อ (AND/OR)

### 3. ข้อมูลที่แสดง
- ชื่อคำถามและคำอธิบาย
- Logic operator (AND/OR)
- ประเภทคำถาม (ใช่/ไม่ใช่, ตัวเลือก, ข้อความ)
- สถานะการใช้งานในการประเมิน

## วิธีการเข้าถึง

### 1. ดูแผนผังของกลุ่มเดียว
1. ไปที่หน้า "จัดการกลุ่มคำถาม"
2. คลิกปุ่ม "ดูแผนผังโครงสร้างคำถาม" (ไอคอน project-diagram) ในแถวของกลุ่มที่ต้องการ
3. ระบบจะแสดงแผนผังโครงสร้างคำถามของกลุ่มนั้น

### 2. ดูแผนผังทั้งหมด
1. ไปที่หน้า "จัดการกลุ่มคำถาม"
2. คลิกปุ่ม "ดูแผนผังโครงสร้างทั้งหมด" ที่ด้านบนขวา
3. หรือคลิกเมนู "แผนผังโครงสร้าง" ในแถบนำทาง

## ไฟล์ที่เกี่ยวข้อง

### Controllers
- `app/Http/Controllers/AdminController.php`
  - `showQuestionTreeStructure()` - แสดงแผนผังของกลุ่มเดียว
  - `showAllQuestionTreeStructure()` - แสดงแผนผังทั้งหมด

### Routes
- `routes/web.php`
  - `admin.question-groups.tree-structure` - แผนผังกลุ่มเดียว
  - `admin.question-groups.all-tree-structure` - แผนผังทั้งหมด

### Views
- `resources/views/admin/question-groups/tree-structure.blade.php` - หน้าแสดงแผนผังกลุ่มเดียว
- `resources/views/admin/question-groups/all-tree-structure.blade.php` - หน้าแสดงแผนผังทั้งหมด
- `resources/views/admin/question-groups/partials/diagram-node.blade.php` - ส่วนประกอบโหนด

### Models
- `app/Models/QuestionGroup.php` - ความสัมพันธ์กับคำถาม
- `app/Models/Question.php` - ความสัมพันธ์ parent-child

## การใช้งาน

### สำหรับผู้ดูแลระบบ
1. **เข้าสู่ระบบ** ด้วยบัญชี admin
2. **ไปที่เมนู** "จัดการคำถาม" หรือ "แผนผังโครงสร้าง"
3. **เลือกกลุ่ม** ที่ต้องการดู หรือดูทั้งหมด
4. **ดูโครงสร้าง** ที่แสดงในรูปแบบแผนผัง

### ฟีเจอร์พิเศษ
- **Static Display**: แสดงโครงสร้างทั้งหมดพร้อมกัน
- **Visual Hierarchy**: แสดงความสัมพันธ์ด้วยเส้นเชื่อม
- **Color Coding**: แยกประเภทโหนดด้วยสี
- **Print Friendly**: รองรับการพิมพ์

## การปรับแต่ง

### เพิ่มสีหรือไอคอนใหม่
แก้ไขในไฟล์ CSS:
```css
.diagram-node-icon.new-type {
    background: #your-color;
    border: 3px solid #your-border-color;
}
```

### สัญลักษณ์ที่ใช้ในปัจจุบัน
- `.and-expandable` - วงกลมทึบสำหรับ AND node ที่มีโหนดย่อย
- `.or-expandable` - สี่เหลี่ยมทึบสำหรับ OR node ที่มีโหนดย่อย  
- `.leaf-node` - วงกลมโปร่งสำหรับโหนดที่ไม่มีโหนดย่อย
- `.and` และ `.or` - สไตล์เก่าที่รองรับเพื่อความเข้ากันได้

### เพิ่มข้อมูลที่แสดง
แก้ไขในไฟล์ `diagram-node.blade.php`:
```php
<div class="diagram-node-details">
    <!-- เพิ่มข้อมูลใหม่ที่นี่ -->
</div>
```

### เปลี่ยนรูปแบบการแสดงผล
แก้ไขในไฟล์ CSS:
```css
.diagram-node-content {
    /* ปรับแต่งรูปแบบที่นี่ */
}
```

## ข้อควรระวัง

1. **Performance**: สำหรับกลุ่มที่มีคำถามจำนวนมาก อาจใช้เวลานานในการโหลด
2. **Memory**: โหลดข้อมูลทั้งหมดพร้อมกัน
3. **Browser Compatibility**: ทดสอบบน browser หลักๆ
4. **Mobile Experience**: ตรวจสอบการแสดงผลบนมือถือ

## การพัฒนาต่อ

### ฟีเจอร์ที่อาจเพิ่มในอนาคต
- **Export to PDF**: ส่งออกแผนผังเป็น PDF
- **Zoom Control**: ปรับขนาดการแสดงผล
- **Filtering**: กรองตามประเภทหรือสถานะ
- **Search Highlight**: ไฮไลท์ผลการค้นหา
- **Print View**: มุมมองสำหรับพิมพ์
- **SVG Export**: ส่งออกเป็นไฟล์ SVG

### การปรับปรุงประสิทธิภาพ
- **Lazy Loading**: โหลดข้อมูลเมื่อต้องการ
- **Caching**: แคชผลลัพธ์การ query
- **Image Optimization**: บีบอัดรูปภาพ
- **CDN**: ใช้ CDN สำหรับ assets

## การทดสอบ

### ทดสอบฟังก์ชันหลัก
1. ✅ การแสดงโครงสร้างถูกต้อง
2. ✅ การแสดงข้อมูลครบถ้วน
3. ✅ การทำงานบนมือถือ
4. ✅ การแสดงผลบน browser ต่างๆ
5. ✅ การพิมพ์

### ทดสอบ Edge Cases
1. ✅ กลุ่มที่ไม่มีคำถาม
2. ✅ คำถามที่ไม่มีโหนดย่อย
3. ✅ ข้อมูลที่ยาวมาก
4. ✅ การใช้งานบน browser ต่างๆ

## การแก้ไขปัญหา

### ปัญหาที่พบบ่อย
1. **แผนผังไม่แสดง**: ตรวจสอบ database relationships
2. **ข้อมูลไม่แสดง**: ตรวจสอบการ query ข้อมูล
3. **CSS ไม่ทำงาน**: ตรวจสอบการโหลด CSS
4. **Performance ช้า**: ตรวจสอบ query optimization

### การ Debug
1. เปิด Developer Tools
2. ตรวจสอบ Console สำหรับ error
3. ตรวจสอบ Network tab สำหรับการโหลดไฟล์
4. ตรวจสอบ Elements tab สำหรับ CSS 