<?php

namespace App\Helpers;
use Illuminate\Support\Facades\Auth;
class UserLevelHelper
{
    /**
     * ตรวจสอบว่าเป็น admin หรือไม่ (ไม่สนใจพิมพ์เล็กพิมพ์ใหญ่)
     */
    public static function isAdmin($user = null)
    {
        if (!$user) {
            $user = Auth::user();
        }
        
        if (!$user) {
            return false;
        }
        
        return strtolower($user->Level) === 'admin';
    }
    
    /**
     * ตรวจสอบว่าเป็น user หรือไม่ (ไม่สนใจพิมพ์เล็กพิมพ์ใหญ่)
     */
    public static function isUser($user = null)
    {
        if (!$user) {
            $user = Auth::user();
        }
        
        if (!$user) {
            return false;
        }
        
        return strtolower($user->Level) === 'user';
    }
    
    /**
     * ตรวจสอบ Level (ไม่สนใจพิมพ์เล็กพิมพ์ใหญ่)
     */
    public static function hasLevel($level, $user = null)
    {
        if (!$user) {
            $user = Auth::user();
        }
        
        if (!$user) {
            return false;
        }
        
        return strtolower($user->Level) === strtolower($level);
    }
    
    /**
     * ตรวจสอบว่าเป็น admin หรือ superadmin (ไม่สนใจพิมพ์เล็กพิมพ์ใหญ่)
     */
    public static function isAdminOrSuperAdmin($user = null)
    {
        if (!$user) {
            $user = Auth::user();
        }
        
        if (!$user) {
            return false;
        }
        
        $level = strtolower($user->Level);
        return $level === 'admin' || $level === 'superadmin';
    }
    
    /**
     * ตรวจสอบว่าเป็น superadmin หรือไม่ (ไม่สนใจพิมพ์เล็กพิมพ์ใหญ่)
     */
    public static function isSuperAdmin($user = null)
    {
        if (!$user) {
            $user = Auth::user();
        }
        
        if (!$user) {
            return false;
        }
        
        return strtolower($user->Level) === 'superadmin';
    }
}
