<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\Agency;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;
use App\Models\AgencyCustomer;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(): View
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'customer_name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'lowercase', 'email', 'max:50', 'unique:customer,Email'],
            'mobile_number' => ['required', 'string', 'max:11'],
            'agency_name' => ['required', 'string', 'max:255'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        // สร้างลูกค้าใหม่ก่อน
        $customer = Customer::create([
            'Customer_Name' => $request->customer_name,
            'Email' => $request->email,
            'Mobile_Number' => $request->mobile_number,
            'Password' => Hash::make($request->password),
            'Level' => 'user',
            'On_Off_Customer' => 'On',
            'Edit_Customer' => 'Off',
            'New_Customer' => 'On',
        ]);

        // ตรวจสอบ Agency ที่มีอยู่แล้ว (ไม่สนใจตัวพิมพ์เล็ก-ใหญ่)
        $existingAgency = Agency::whereRaw('LOWER(Agency_Name) = ?', [strtolower($request->agency_name)])->first();

        if ($existingAgency) {
            // ใช้ Agency ที่มีอยู่แล้ว
            $agency = $existingAgency;
            
            // อัปเดตข้อมูล Agency ถ้าจำเป็น
            if ($existingAgency->New_Agency === 'On') {
                $existingAgency->update([
                    'New_Agency' => 'Off',
                    'CusUdp_ID' => $customer->Customer_ID,
                    'DtmUdp' => now()
                ]);
            }
        } else {
            // สร้างหน่วยงานใหม่
            $agency = Agency::create([
                'Agency_Name' => $request->agency_name,
                'Tax_ID' => '', // ค่าเริ่มต้น
                'Address' => '', // ค่าเริ่มต้น
                'Address_Sent' => '', // ค่าเริ่มต้น
                'Address_Test' => '', // ค่าเริ่มต้น
                'Address_Eng' => '', // ค่าเริ่มต้น
                'Office_Number' => '', // ค่าเริ่มต้น
                'Web_Name' => '', // ค่าเริ่มต้น
                'active' => 1,
                'CusIns_ID' => $customer->Customer_ID,
                'CusUdp_ID' => $customer->Customer_ID,
                'Note' => '', // ค่าเริ่มต้น
                'Edit_Agency' => 'Off',
                'New_Agency' => 'On',
            ]);
        }

        // อัปเดต CusIns_ID และ CusUdp_ID ของ customer และใส่ Agency_ID
        $customer->update([
            'CusIns_ID' => $customer->Customer_ID,
            'CusUdp_ID' => $customer->Customer_ID,
            'Agency_ID' => $agency->Agency_ID,
        ]);

        // สร้างความสัมพันธ์ในตาราง agency_customer
        AgencyCustomer::create([
            'Customer_ID' => $customer->Customer_ID,
            'Agency_ID' => $agency->Agency_ID,
        ]);

        event(new Registered($customer));

        Auth::login($customer);

        return redirect(route('dashboard', absolute: false));
    }
}

