<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // ตรวจสอบว่าผู้ใช้ล็อกอินแล้วหรือไม่
        if (!Auth::check()) {
            // Redirect ไป ServTrack แทน Laravel login
            return redirect()->route('login');
        }

        // ตรวจสอบว่าผู้ใช้เป็น admin หรือ superadmin
        $userLevel = strtolower(Auth::user()->Level);
        if ($userLevel !== 'admin' && $userLevel !== 'superadmin') {
            return redirect()->route('dashboard')->with('error', 'คุณไม่มีสิทธิ์เข้าถึงหน้านี้');
        }

        return $next($request);
    }
}
