<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Product extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<string>
     */
    protected $fillable = [
        'name',
        'model',
        'log_receive_method',
        'product_type',
        'description',
        'image',
        'user_id',
        'Agency_ID',
        'CusIns_ID',
        'CusUdp_ID',
    ]; //fillable ช่วยให้ laravel ทำ Product::create($validated) ได้อย่างปลอดภัย

    // กำหนดชื่อ timestamp columns
    const CREATED_AT = 'DtmIns';
    const UPDATED_AT = 'DtmUpd';

    /**
     * Get the user that owns the product.
     */
    public function user()
    {
        return $this->belongsTo(Customer::class, 'user_id', 'Customer_ID');
    }
    
    /**
     * Get the agency that owns the product.
     */
    public function agency()
    {
        return $this->belongsTo(Agency::class, 'Agency_ID', 'Agency_ID');
    }
    
    /**
     * Get the assessments for the product.
     */
    public function assessments()
    {
        return $this->hasMany(Assessment::class);//ดึงการประเมิณทั้งหมดของผลิตภัณฑ์นี้
    }
    //laravel จะใช้ relationships ในการทำงาน เช่น $product->assessments จะดึงการประเมิณทั้งหมดของผลิตภัณฑ์นี้ , $product->user จะดึงผู้ใช้งานที่สร้างผลิตภัณฑ์นี้

    /**
     * Get the product type label.
     */
    public function getProductTypeLabelAttribute()
    {
        return match($this->product_type) {
            'hw_sw_log_server' => 'Hardware + Software Log Server',
            'sw_log_server' => 'Software Log Server',
            default => $this->product_type,
        };
    }

    /**
     * Get the log receive method label.
     */
    public function getLogReceiveMethodLabelAttribute()
    {
        return match($this->log_receive_method) {
            'syslog_udp' => 'syslog UDP',
            'syslog_tcp' => 'syslog TCP',
            'syslog_both' => 'syslog UDP และ syslog TCP',
            'other' => 'อื่นๆ',
            default => $this->log_receive_method,
        };
    }
}
