<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Drop foreign key constraints first
        DB::statement("ALTER TABLE question_groups DROP FOREIGN KEY question_groups_cusins_id_foreign");
        DB::statement("ALTER TABLE question_groups DROP FOREIGN KEY question_groups_cusudp_id_foreign");

        // Add comments to all columns
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN id BIGINT UNSIGNED AUTO_INCREMENT COMMENT 'รหัสกลุ่มคำถาม'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN name VARCHAR(255) COMMENT 'ชื่อกลุ่มคำถาม'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN description TEXT NULL DEFAULT NULL COMMENT 'คำอธิบายกลุ่มคำถาม'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN is_active TINYINT(1) DEFAULT 1 COMMENT 'สถานะการใช้งาน (1=ใช้งาน, 0=ไม่ใช้งาน)'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN type VARCHAR(255) DEFAULT 'manual' COMMENT 'ประเภทการประเมิน (manual=ด้วยตนเอง, auto=อัตโนมัติ)'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN created_by BIGINT UNSIGNED COMMENT 'รหัสผู้สร้าง'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'วันที่และเวลาที่สร้าง'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'วันที่และเวลาที่แก้ไขล่าสุด'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN CusIns_ID INT UNSIGNED COMMENT 'รหัสลูกค้าผู้สร้าง'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN CusUdp_ID INT UNSIGNED COMMENT 'รหัสลูกค้าผู้แก้ไข'");

        // Re-add foreign key constraints
        DB::statement("ALTER TABLE question_groups ADD CONSTRAINT question_groups_cusins_id_foreign FOREIGN KEY (CusIns_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE question_groups ADD CONSTRAINT question_groups_cusudp_id_foreign FOREIGN KEY (CusUdp_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Drop foreign key constraints first
        DB::statement("ALTER TABLE question_groups DROP FOREIGN KEY question_groups_cusins_id_foreign");
        DB::statement("ALTER TABLE question_groups DROP FOREIGN KEY question_groups_cusudp_id_foreign");

        // Remove comments from all columns
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN id BIGINT UNSIGNED AUTO_INCREMENT");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN name VARCHAR(255)");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN description TEXT NULL DEFAULT NULL");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN is_active TINYINT(1) DEFAULT 1");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN type VARCHAR(255) DEFAULT 'manual'");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN created_by BIGINT UNSIGNED");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN CusIns_ID INT UNSIGNED");
        DB::statement("ALTER TABLE question_groups MODIFY COLUMN CusUdp_ID INT UNSIGNED");

        // Re-add foreign key constraints
        DB::statement("ALTER TABLE question_groups ADD CONSTRAINT question_groups_cusins_id_foreign FOREIGN KEY (CusIns_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE question_groups ADD CONSTRAINT question_groups_cusudp_id_foreign FOREIGN KEY (CusUdp_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
    }
};
