# SAS Log Assessment System

ระบบประเมินผลิตภัณฑ์ Log Server สำหรับการทดสอบและประเมินผล

## ความต้องการของระบบ

- PHP 8.0 หรือสูงกว่า
- MySQL 5.7 หรือสูงกว่า
- Composer
- Web Server (Apache/Nginx)

## วิธีติดตั้ง

### 1. คัดลอกโปรเจคไปยังเซิร์ฟเวอร์

### 2. ติดตั้ง Dependencies
```bash
composer install
```

### 3. สร้างไฟล์ .env
```bash
cp .env.example .env
```

### 4. สร้าง Application Key
```bash
php artisan key:generate
```

### 5. ตั้งค่าฐานข้อมูลใน .env
```env
DB_DATABASE=sas_log
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

### 6. รัน Migration
```bash
php artisan migrate
```

### 7. รัน Seeder (ถ้าต้องการข้อมูลทดสอบ)
```bash
php artisan db:seed
```

### 8. สร้าง Storage Link
```bash
php artisan storage:link
```

### 9. ตั้งค่าสิทธิ์
```bash
chmod -R 755 storage bootstrap/cache
```

### 10. รันโปรเจค
```bash
php artisan serve
```

## ข้อมูลทดสอบ

### Admin User:
- Email: admin@example.com
- Password: password

### User ทั่วไป:
- Email: user@example.com  
- Password: password

## ฟีเจอร์หลัก

- ระบบจัดการผู้ใช้ (Admin/User)
- ระบบจัดการผลิตภัณฑ์
- ระบบประเมินผล (Assessment)
- ระบบจัดการคำถาม (Question Groups)
- ระบบรายงานผลการประเมิน

## การใช้งาน

### สำหรับ Admin:
1. เข้าสู่ระบบด้วย Admin Account
2. จัดการผู้ใช้ (เปิด/ปิดการใช้งาน)
3. จัดการกลุ่มคำถาม (Question Groups)
4. จัดการคำถาม (Questions)
5. ดูรายงานการประเมิน

### สำหรับ User ทั่วไป:
1. สร้างผลิตภัณฑ์
2. ทำแบบประเมิน
3. บันทึกฉบับร่าง
4. ดูรายงานผลการประเมิน

## หมายเหตุ

โปรเจคนี้สร้างขึ้นเพื่อการทดสอบเท่านั้น ไม่แนะนำให้ใช้ในระบบจริง

## การแก้ไขปัญหา

### หากเกิด Error:
1. ตรวจสอบการตั้งค่าฐานข้อมูลใน .env
2. รัน `php artisan config:clear`
3. รัน `php artisan cache:clear`
4. ตรวจสอบสิทธิ์ของโฟลเดอร์ storage และ bootstrap/cache

### หากไม่สามารถอัปโหลดรูปภาพ:
1. รัน `php artisan storage:link`
2. ตรวจสอบสิทธิ์ของโฟลเดอร์ storage/app/public

## การติดต่อ

หากมีปัญหาหรือคำถาม กรุณาติดต่อผู้พัฒนา
