<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Answer extends Model
{
    protected $fillable = [
        'assessment_id',
        'question_id',
        'answer_text',
        'image_path',
        'comment',
        'CusIns_ID',
        'CusUdp_ID',
    ];

    // กำหนดชื่อ timestamp columns
    const CREATED_AT = 'DtmIns';
    const UPDATED_AT = 'DtmUpd';

    public function question()
    {
        return $this->belongsTo(Question::class);
    }
    public function assessment()
    {
        return $this->belongsTo(Assessment::class);
    }
}
