<?php
session_start();
require_once 'config/db.php';

// เช็คว่ามีการส่งฟอร์มหรือไม่
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ตรวจสอบว่ามีการกรอก Address_Sentip หรือไม่
    if (isset($_POST['Address_Sentip'])) {
        $_SESSION['Address_Sentip'] = $_POST['Address_Sentip'];

        // เคลียร์ค่าที่กรอกเมื่อส่งฟอร์ม
        unset($_SESSION['Address_Sentip']);
    }
}

// Query เพื่อดึง Customer_ID ล่าสุด
$sqlCustomer = "SELECT MAX(Customer_ID) AS LastCustomerID FROM customer";
$resultCustomer = $conn->query($sqlCustomer);

if ($resultCustomer->rowCount() > 0) {
    $rowCustomer = $resultCustomer->fetch(PDO::FETCH_ASSOC);
    $nextCustomerID = $rowCustomer['LastCustomerID'] + 1; // เพิ่ม 1 จาก ID ล่าสุด
} else {
    $nextCustomerID = 1; // กรณีไม่มีข้อมูลในตาราง ให้เริ่มต้นที่ 1
}

// Query เพื่อดึง Agency_Customer_ID ล่าสุดจากตาราง agency_customer
$sqlAgencyCustomer = "SELECT MAX(Agency_Customer_ID) AS LastAgencyCustomerID FROM agency_customer";
$resultAgencyCustomer = $conn->query($sqlAgencyCustomer);

if ($resultAgencyCustomer->rowCount() > 0) {
    $rowAgencyCustomer = $resultAgencyCustomer->fetch(PDO::FETCH_ASSOC);
    // ตรวจสอบว่ามีค่า LastAgencyCustomerID หรือไม่
    if (isset($rowAgencyCustomer['LastAgencyCustomerID'])) {
        $nextAgencyCustomer = $rowAgencyCustomer['LastAgencyCustomerID'] + 1; // เพิ่ม 1 จาก ID ล่าสุด
    } else {
        $nextAgencyCustomer = 1; // กรณีไม่มีค่าในคอลัมน์ LastAgencyCustomerID ให้เริ่มต้นที่ 1
    }
} else {
    $nextAgencyCustomer = 1; // กรณีไม่มีข้อมูลในตารางให้เริ่มต้นที่ 1
}


// Query เพื่อดึง Agency_ID ล่าสุดจากตาราง agency
$sqlAgency = "SELECT MAX(Agency_ID) AS LastAgencyID FROM agency";
$resultAgency = $conn->query($sqlAgency);

if ($resultAgency->rowCount() > 0) {
    $rowAgency = $resultAgency->fetch(PDO::FETCH_ASSOC);
    // ตรวจสอบว่ามีค่า LastAgencyCustomerID หรือไม่
    if (isset($rowAgency['LastAgencyID'])) {
        $nextAgencyID = $rowAgency['LastAgencyID'] + 1; // เพิ่ม 1 จาก ID ล่าสุด
    } else {
        $nextAgencyID = 1; // กรณีไม่มีค่าในคอลัมน์ LastAgencyCustomerID ให้เริ่มต้นที่ 1
    }
} else {
    $nextAgencyID = 1; // กรณีไม่มีข้อมูลในตารางให้เริ่มต้นที่ 1
}
if (isset($_POST['check_tax_id'])) {
  $tax_id = $_POST['tax_id'];
  $stmt = $conn->prepare("SELECT * FROM agency WHERE Tax_ID = :tax_id");
  $stmt->execute([':tax_id' => $tax_id]);
  $result = $stmt->fetch(PDO::FETCH_ASSOC);
  
  if ($result) {
      echo json_encode([
          'exists' => true,
          'agency_name' => $result['Agency_Name'],
          'address' => $result['Address'],
          'address_sent' => $result['Address_Sent'],
          'address_test' => $result['Address_Test'],
          'office_number' => $result['Office_Number'],
          'web_name' => $result['Web_Name']
      ]);
  } else {
      echo json_encode(['exists' => false]);
  }
  exit();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title><?php  require_once 'Title.php';?></title>
</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="assets/img/favicon.ico" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Kanit">
  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

  <!-- SweetAlert2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

<!-- SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



  <!-- =======================================================
  * Template Name: NiceAdmin - v2.5.0
  * Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<style>
  .input-success {
    border: 2px solid lightgreen;
    border-radius: 5px;
    box-shadow: 0 0 5px lightgreen;
}

  </style>

<body>
  <!-- ======= Header ======= -->
  <header id="header" class="header fixed-top d-flex align-items-center">

    <div class="d-flex align-items-center justify-content-between">
      <a href="Login.php" class="logo d-flex align-items-center">
        <img src="assets/img/Logo SQUAT_horizontal.jpg" alt="">
      </a>
      <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->
  </header><!-- End Header -->

 

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>ลงทะเบียนผู้ใช้งาน</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="Login.php">Login</a></li>
          <li class="breadcrumb-item">ลงทะเบียนผู้ใช้งาน</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

<!-- Section 1 -->
<section class="section">
            <div class="row">
              <div class="col-lg-6">
              <div class="card">
                  <div class="card-body">
                  <h5 class="card-title" style="font-weight: bold;">ข้อมูลผู้ติดต่อ</h5>

                  <form action="registerAdd.php" method="post">

                  <?php 
                    if (isset($_SESSION ['error'])) { 
                  ?><div class="alert alert-danger" role="alert">
                  <?php
                    echo $_SESSION ['error'];
                    unset ($_SESSION ['error']);
                  ?></div>
                  <?php } ?>

                  <?php 
if (isset($_SESSION['success'])) { 
  echo "<script>
    Swal.fire({
      icon: 'success',
      title: 'Success',
      text: '" . $_SESSION['success'] . "',
      confirmButtonText: 'ตกลง'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = 'Login.php';
      }
    });
  </script>";
  unset($_SESSION['success']);
} 
?>

                  <?php 
                    if (isset($_SESSION ['warning'])) { 
                  ?><div class="alert alert-warning" role="alert">
                  <?php
                    echo $_SESSION ['warning'];
                    unset ($_SESSION ['warning']);
                  ?>
                  </div>
                  <?php } ?>
              <!-- 


<?php 
if (isset($_SESSION['warning'])) { 
  echo "<script>
    Swal.fire({
      icon: 'warning',
      title: 'Warning',
      html: '" . $_SESSION['warning'] . "'
    });
  </script>";
  unset($_SESSION['warning']);
} 
?>

<?php 
if (isset($_SESSION['success'])) { 
  echo "<script>
    Swal.fire({
      icon: 'success',
      title: 'Success',
      text: '" . $_SESSION['success'] . "',
      confirmButtonText: 'ตกลง'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = 'Login.php';
      }
    });
  </script>";
  unset($_SESSION['success']);
} 
?> -->





                  <div class="row mb-3">
                        <label  style="width: 100%;" for="Customer_Name" class="col-sm-2 col-form-label">ผู้ติดต่อ (ไม่ต้องกรอกคำนำหน้าชื่อ )<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control" placeholder="กรุณากรอก ชื่อ-นามสกุล" name="Customer_Name" value="<?php echo isset($_SESSION['Customer_Name']) ? $_SESSION['Customer_Name'] : ''; ?>">
                        </div>
                      </div>
                      

                      <div class="row mb-3">
                        <label  style="width: 100%;" for="Mobile_Number" class="col-sm-2 col-form-label">เบอร์โทรศัพท์ผู้ติดต่อ ( โทรศัพท์มือถือ ตัวเลข 10 หลักเท่านั้น )<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control" placeholder="กรุณากรอก เบอร์โทรศัพท์มือถือ" name="Mobile_Number" value="<?php echo isset($_SESSION['Mobile_Number']) ? $_SESSION['Mobile_Number'] : ''; ?>">
                        </div>
                      </div>

                      <div class="row mb-3">
                        <label  style="width: 100%;" for="Email" class="col-sm-2 col-form-label">e-mail<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="email" class="form-control" placeholder="กรุณากรอก E-mail*" name="Email" value="<?php echo isset($_SESSION['Email']) ? $_SESSION['Email'] : ''; ?>">
                        </div>
                      </div>

                      <div class="row mb-3">
                        <label  style="width: 100%;" for="Password" class="col-sm-2 col-form-label">Password <a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="Password" class="form-control" placeholder="รหัสผ่านต้องมีความยาวขนาดระหว่าง 8-20 ตัวอักษร*" name="Password" value="<?php echo isset($_SESSION['Password']) ? $_SESSION['Password'] : ''; ?>">
                        </div>
                      </div>

                      <div class="row mb-3">
                        <label  style="width: 100%;" for="c_password" class="col-sm-2 col-form-label">Confirm Password<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                          <input type="Password" class="form-control" placeholder="รหัสผ่านต้องมีความยาวขนาดระหว่าง 8-20 ตัวอักษร*" name="c_password" value="<?php echo isset($_SESSION['c_password']) ? $_SESSION['c_password'] : ''; ?>">
                        </div>
                      </div>

                      <div class="row mb-3"hidden>
                        <label  style="width: 100%;" for="New_Customer" class="col-sm-2 col-form-label">New_Customer<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control"  name="New_Customer" value="On">
                        </div>
                      </div>

                      <div class="row mb-3" hidden>
                        <label  style="width: 100%;" for="On_Off_Customer" class="col-sm-2 col-form-label">On_Off_Customer<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control"  name="On_Off_Customer" value="Off">
                        </div>
                      </div>

                      <div class="row mb-3" hidden>
                        <label  style="width: 100%;" for="Edit_Customer" class="col-sm-2 col-form-label">Edit_Customer<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control"  name="Edit_Customer" value="Off" readonly>
                        </div>
                      </div>

                    </section>
                    <div id="agencyMessage" style="display: none;">
                    </div>

<!-- Section 2 -->
    <section class="section"id="agencyFormSection">
      <div class="row">
        <div class="col-lg-6">
          <div class="card">
            <div class="card-body">
              <h5 class="card-title"style="font-weight: bold;">ข้อมูลหน่วยงาน</h5>
              <?php
if (isset($_SESSION['warning_agency'])) {
    echo '<div class="alert alert-warning" role="alert">' . $_SESSION['warning_agency'] . '</div>';
    unset($_SESSION['warning_agency']);
}
?>

<div id="agencyMessage" style="display: none;"></div>
                <div class="row mb-3">
                  <label  style="width: 100%;" for="Tax_ID" class="col-sm-2 col-form-label">เลขประจำตัวผู้เสียภาษีของหน่วยงาน ( กรอกข้อมูลเลข 13 หลัก เพื่อใช้ตรวจสอบข้อมูลในฐานข้อมูล )<a style="color: #FF0000;">*</a></label>
                  <div class="col-sm-10">
                  <input type="text" class="form-control" 
       placeholder="กรอกเลขประจำตัวผู้เสียภาษี" 
       id="taxIdInput"
       name="Tax_ID" 
       value="<?php echo isset($_SESSION['Tax_ID']) ? $_SESSION['Tax_ID'] : ''; ?>"
       onkeyup="checkTaxID(this.value)">
                  </div>
                </div>

                <div class="row mb-3">
                  <label style="width: 100%;" for="Agency_Name" class="col-sm-2 col-form-label">ชื่อหน่วยงาน ( ที่จดทะเบียนพาณิชย์ )<a style="color: #FF0000;">*</a></label>
                  <div class="col-sm-10">
                  <input type="text" class="form-control" placeholder="กรอกชื่อหน่วยงาน" name="Agency_Name" value="<?php echo isset($_SESSION['Agency_Name']) ? $_SESSION['Agency_Name'] : ''; ?>">
                  </div>
                </div>

              
                
                <div class="row mb-3">
                  <label style="width: 100%;" for="Address" class="col-sm-2 col-form-label">ที่อยู่ภาษาไทยสำหรับทำใบเสนอราคา,ใบเสร็จรับเงิน ( ที่จดทะเบียนพาณิชย์ )<a style="color: #FF0000;">*</a></label>
                  <div class="col-sm-10">
                    <input type="text" class="form-control" placeholder="กรอกที่อยู่ภาษาไทย" name="Address" value="<?php echo isset($_SESSION['Address']) ? $_SESSION['Address'] : ''; ?>">
                  </div>
                </div>

                <fieldset class="row mb-3">
                  <legend class="col-form-label col-sm-2" style="width: 100%;">ที่อยู่สำหรับจัดส่งเอกสาร<a style="color: #FF0000;">*</a></legend>
                  <div class="col-sm-10">
                    <div class="form-check">
                      <input type="radio" id="checkbox2" class="form-check-input" value="ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์" name="Address_Sent" <?php echo (isset($_SESSION['Address_Sent']) && $_SESSION['Address_Sent'] == "ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์") ? 'checked' : ''; ?>>
                      <label class="form-check-label" for="gridCheck1" style="width: 100%;">ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์</label>
                    </div>

                    <div class="form-check">
                      <input type="radio" id="checkbox1" class="form-check-input" name="Address_Sent" 
       value="<?php echo isset($_SESSION['Address_Sentip']) ? $_SESSION['Address_Sentip'] : ''; ?>" 
       <?php echo (isset($_SESSION['Address_Sent']) && $_SESSION['Address_Sent'] != "ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์") ? 'checked' : ''; ?>>
<label class="form-check-label" for="checkbox1">อื่น ๆ</label>
<input type="text" id="input1" 
       style="display:<?php echo (isset($_SESSION['Address_Sent']) && $_SESSION['Address_Sent'] != "ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์") ? 'block' : 'none'; ?>;" 
       class="form-control mt-2" 
       name="Address_Sentip" 
       value="<?php echo (isset($_SESSION['Address_Sentip']) ? $_SESSION['Address_Sentip'] : ''); ?>">
        </div>
                </fieldset>
<!-- -----------------------------------NEW-------------------------------------------------------- -->
<fieldset class="row mb-3">
                  <legend class="col-form-label col-sm-2" style="width: 100%;">ที่อยู่สำหรับจัดทำรายงานผลการทดสอบ<a style="color: #FF0000;">*</a></legend>
                  <div class="col-sm-10">
                    <div class="form-check">
                      <input class="form-check-input" type="radio" id="radio3" name="Address_Test" value="ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์" <?php echo (isset($_SESSION['Address_Test']) && $_SESSION['Address_Test'] == "ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์") ? 'checked' : ''; ?>>
                      <label class="form-check-label" for="gridCheck3">ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์</label>
                    </div>

                    <div class="form-check">
                      <input class="form-check-input" type="radio" id="radio4" name="Address_Test" value="ที่อยู่สำหรับจัดส่งเอกสาร" <?php echo (isset($_SESSION['Address_Test']) && $_SESSION['Address_Test'] == "ที่อยู่สำหรับจัดส่งเอกสาร") ? 'checked' : ''; ?>>
                      <label class="form-check-label" for="gridCheck4">ที่อยู่เดียวกันกับที่อยู่จัดส่งเอกสาร</label>
                    </div>

                        <div class="row mb-3">
                          <label  style="width: 100%;" for="Address_Eng" class="col-sm-2 col-form-label" hidden>ที่อยู่ภาษาอังกฤษ</label>
                          <div class="col-sm-10">
                        <input type="text" class="form-control"placeholder="กรอกที่อยู่ภาษาอังกฤษ" name="Address_Eng"hidden>
                      </div>
                    </div> 
                    <div class="row mb-3">
                        <label  style="width: 100%;" for="Office_Number" class="col-sm-2 col-form-label">เบอร์โทรศัพท์สำนักงาน ( พร้อมเบอร์ต่อหากมี )</label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control" placeholder="กรุณากรอก เบอร์โทรศัพท์สำนักงาน" name="Office_Number" value="<?php echo isset($_SESSION['Office_Number']) ? $_SESSION['Office_Number'] : ''; ?>">
                        </div>
                      </div>

                      <div class="row mb-3">
                        <label  style="width: 100%;" for="Web_Name" class="col-sm-2 col-form-label">เว็บไซต์หน่วยงาน หรือเว็บไซต์ผลิตภัณฑ์</label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control" placeholder="กรอกเว็บไซต์หน่วยงาน หรือ เว็บไซต์ผลิตภัณฑ์" name="Web_Name" value="<?php echo isset($_SESSION['Web_Name']) ? $_SESSION['Web_Name'] : ''; ?>">
                        </div>
                      </div>

              
                     <div class="row mb-3" hidden>
                        <label  style="width: 100%;" for="On_Off_Agency" class="col-sm-2 col-form-label">On_Off_Agency<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control"  name="On_Off_Agency" value="Off" readonly>
                        </div>
                      </div>
                      <div class="row mb-3" hidden>
                        <label  style="width: 100%;" for="Edit_Agency" class="col-sm-2 col-form-label">Edit_Agency<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control"  name="Edit_Agency" value="Off" readonly>
                        </div>
                      </div>

                      <div class="row mb-3"hidden>
                        <label  style="width: 100%;" for="New_Agency" class="col-sm-2 col-form-label">New_Agency<a style="color: #FF0000;">*</a></label>
                        <div class="col-sm-10">
                        <input type="text" class="form-control"  name="New_Agency" value="On">
                        </div>
                      </div>
              

                    </fieldset>
                      </div>
                </section>
                </div>
                
                 

<!-- Section 3 -->
        

                  <div class="col-sm-10">
                    <button type="submit" name="signup" class="btn btn-primary">ยืนยัน</button>
                  </div>
                </div>

              </form><!-- End General Form Elements -->

            </div>
          </div>

        </div>

        

             
    </section>

  </main><!-- End #main -->

   <!-- ======= Footer ======= -->
   <?php include('Footer.php');?>
  <!-- End Footer -->

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.min.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>

   <!-- Template Main JS File -->

   <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



  <script>
  let input1 = document.getElementById("input1");
let check1 = document.getElementById("checkbox1");
let check2 = document.getElementById("checkbox2");

// เมื่อเลือก checkbox1 จะเปิด input1 ขึ้นมา
check1.addEventListener("change", function() {
  if (check1.checked) {
    input1.style.display = "block";
  } else {
    input1.style.display = "none";
  }
  check2.checked = false;
});

// เมื่อเลือก checkbox2 จะซ่อน input1
check2.addEventListener("change", function() {
  if (check2.checked) {
    input1.style.display = "none";
  }
  check1.checked = false;
});

// ดักจับการกรอกข้อมูลใน input และอัปเดตค่า value ของ radio button
input1.addEventListener("input", function() {
  check1.value = input1.value; // อัปเดตค่า value ของ checkbox1 ด้วยค่าที่กรอกใน input1
});

  </script>
 
 <script>
function checkTaxID(taxID) {
    if (taxID.length === 13) {
        const formData = new FormData();
        formData.append('check_tax_id', '1');
        formData.append('tax_id', taxID);

        fetch(window.location.href, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            const agencyForm = document.getElementById('agencyFormSection');
            const agencyMessage = document.getElementById('agencyMessage');
            
            if (data.exists) {
                // Show a notification that existing data was found
                agencyMessage.innerHTML = `
                    <div class="row mb-3">
    <div class="col-12">
        <div class="alert alert-info" role="alert" style="background-color: #e6ffe6; color: darkgreen; border-color: #a8d08d; width: 100%; max-width: 1100px;">
            <h4 class="alert-heading">พบข้อมูลหน่วยงานในระบบ</h4>
            <p>ระบบจะดึงข้อมูลหน่วยงานที่มีอยู่มาแสดงให้อัตโนมัติ</p>
        </div>
    </div>
</div>

`;
                agencyMessage.style.display = 'block';
                
                // Auto-populate form fields
                document.querySelector('input[name="Agency_Name"]').value = data.agency_name || '';
                document.querySelector('input[name="Address"]').value = data.address || '';
                document.querySelector('input[name="Office_Number"]').value = data.office_number || '';
                document.querySelector('input[name="Web_Name"]').value = data.web_name || '';
                
                // Handle Address_Sent radio buttons and input
                if (data.address_sent === "ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์") {
                    document.getElementById('checkbox2').checked = true;
                    document.getElementById('checkbox1').checked = false;
                    document.getElementById('input1').style.display = 'none';
                } else {
                    document.getElementById('checkbox1').checked = true;
                    document.getElementById('checkbox2').checked = false;
                    document.getElementById('input1').style.display = 'block';
                    document.getElementById('input1').value = data.address_sent || '';
                }
                
                // Handle Address_Test radio buttons
                if (data.address_test === "ที่อยู่เดียวกันกับที่อยู่ที่จดทะเบียนพาณิชย์") {
                    document.getElementById('radio3').checked = true;
                } else if (data.address_test === "ที่อยู่สำหรับจัดส่งเอกสาร") {
                    document.getElementById('radio4').checked = true;
                }
                
                // Keep the form visible
                agencyForm.style.display = 'block';
            } else {
                // Clear the notification if no data found
                agencyMessage.style.display = 'none';
                agencyForm.style.display = 'block';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            // Show error message to user
            agencyMessage.innerHTML = `
                <div class="alert alert-danger" role="alert">
                    เกิดข้อผิดพลาดในการดึงข้อมูล กรุณาลองใหม่อีกครั้ง
                </div>`;
            agencyMessage.style.display = 'block';
        });
    } else if (taxID.length === 0) {
        // Clear notification and show empty form when Tax ID is cleared
        document.getElementById('agencyFormSection').style.display = 'block';
        document.getElementById('agencyMessage').style.display = 'none';
    }
}

// Add Tax ID input validation
document.getElementById('taxIdInput').addEventListener('input', function(e) {
    // Allow only numbers
    this.value = this.value.replace(/[^0-9]/g, '');
    
    // Limit to 13 digits
    if (this.value.length > 13) {
        this.value = this.value.slice(0, 13);
    }
});
</script>
  
</body>

</html>