<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // เปลี่ยนชื่อ created_at เป็น DtmIns และ updated_at เป็น DtmUpd
            $table->renameColumn('created_at','DtmIns');
            $table->renameColumn('updated_at','DtmUpd');
        });

        //แก้ไขค่า default และ on update ด้วย raw sql
        DB::statement("ALTER TABLE users MODIFY DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
        DB::statement("ALTER TABLE users MODIFY DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //
            $table->renameColumn('DtmIns','created_at');
            $table->renameColumn('DtmUpd','updated_at');
        });
        DB::statement("ALTER TABLE users MODIFY created_at TIMESTAMP NULL DEFAULT NULL");
        DB::statement("ALTER TABLE users MODIFY updated_at TIMESTAMP NULL DEFAULT NULL");
    }
};
