<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // เพิ่ม comment ให้คอลัมภ์ที่ไม่มี Foreign Key ก่อน
        DB::statement("ALTER TABLE assessments MODIFY COLUMN id BIGINT UNSIGNED AUTO_INCREMENT COMMENT 'รหัสการประเมิน'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN status ENUM('draft','submitted','completed') DEFAULT 'draft' COMMENT 'สถานะการประเมิน (draft=ฉบับร่าง, submitted=ส่งแล้ว, completed=เสร็จสิ้น)'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN started_at TIMESTAMP NULL DEFAULT NULL COMMENT 'วันที่และเวลาเริ่มประเมิน'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN submitted_at TIMESTAMP NULL DEFAULT NULL COMMENT 'วันที่และเวลาส่งการประเมิน'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN note TEXT NULL DEFAULT NULL COMMENT 'หมายเหตุการประเมิน'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'วันที่และเวลาที่สร้างข้อมูล'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'วันที่และเวลาที่แก้ไขข้อมูล'");

        // จัดการคอลัมภ์ที่มี Foreign Key Constraint
        // ลบ Foreign Key ก่อน (ใช้ชื่อที่ถูกต้อง)
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_user_id_foreign");
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_product_id_foreign");
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_question_group_id_foreign");
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_cusins_id_foreign");
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_cusudp_id_foreign");
        
        // เพิ่ม comment ให้คอลัมภ์ที่มี Foreign Key
        DB::statement("ALTER TABLE assessments MODIFY COLUMN user_id INT UNSIGNED COMMENT 'รหัสผู้ใช้ที่ทำการประเมิน'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN product_id BIGINT UNSIGNED COMMENT 'รหัสผลิตภัณฑ์ที่ถูกประเมิน'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN question_group_id BIGINT UNSIGNED COMMENT 'รหัสกลุ่มคำถามที่ใช้ในการประเมิน'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN CusIns_ID INT UNSIGNED COMMENT 'รหัสลูกค้าที่สร้างข้อมูล'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN CusUdp_ID INT UNSIGNED COMMENT 'รหัสลูกค้าที่แก้ไขข้อมูล'");
        
        // เพิ่ม Foreign Key กลับมา (ใช้ชื่อและกฎเดิม)
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_user_id_foreign FOREIGN KEY (user_id) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_product_id_foreign FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE");
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_question_group_id_foreign FOREIGN KEY (question_group_id) REFERENCES question_groups(id) ON DELETE RESTRICT");
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_cusins_id_foreign FOREIGN KEY (CusIns_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_cusudp_id_foreign FOREIGN KEY (CusUdp_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // ลบ Foreign Key ก่อน (ใช้ชื่อที่ถูกต้อง)
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_user_id_foreign");
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_product_id_foreign");
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_question_group_id_foreign");
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_cusins_id_foreign");
        DB::statement("ALTER TABLE assessments DROP FOREIGN KEY assessments_cusudp_id_foreign");
        
        // ลบ comment โดยไม่ระบุ comment
        DB::statement("ALTER TABLE assessments MODIFY COLUMN id BIGINT UNSIGNED AUTO_INCREMENT");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN user_id INT UNSIGNED");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN product_id BIGINT UNSIGNED");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN question_group_id BIGINT UNSIGNED");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN status ENUM('draft','submitted','completed') DEFAULT 'draft'");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN started_at TIMESTAMP NULL DEFAULT NULL");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN submitted_at TIMESTAMP NULL DEFAULT NULL");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN note TEXT NULL DEFAULT NULL");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN CusIns_ID INT UNSIGNED");
        DB::statement("ALTER TABLE assessments MODIFY COLUMN CusUdp_ID INT UNSIGNED");
        
        // เพิ่ม Foreign Key กลับมา (ใช้ชื่อและกฎเดิม)
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_user_id_foreign FOREIGN KEY (user_id) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_product_id_foreign FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE");
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_question_group_id_foreign FOREIGN KEY (question_group_id) REFERENCES question_groups(id) ON DELETE RESTRICT");
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_cusins_id_foreign FOREIGN KEY (CusIns_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE assessments ADD CONSTRAINT assessments_cusudp_id_foreign FOREIGN KEY (CusUdp_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
    }
};
