<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>รายงานผลการประเมินผลิตภัณฑ์</title>
    <style>
        body {
            font-family: 'DejaVu Sans', 'Arial Unicode MS', 'Arial', 'Helvetica', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        
        .container-fluid {
            width: 100%;
            max-width: none;
            padding: 0;
            margin: 0;
        }
        
        .row {
            margin: 0;
        }
        
        .col-12, .col-md-12, .col-md-6 {
            padding: 0;
            width: 100%;
        }
        
        .card {
            border: none;
            box-shadow: none;
            margin-bottom: 20px;
        }
        
        .card-header {
            background-color: #f8f9fa;
            color: #000;
            border-bottom: 2px solid #000;
            padding: 10px;
            margin-bottom: 15px;
        }
        
        .card-header h4, .card-header h5 {
            margin: 0;
            font-size: 14px;
            font-weight: bold;
        }
        
        .card-body {
            padding: 0;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 10px;
        }
        
        .table th, .table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        
        .table-dark {
            background-color: #f8f9fa;
            color: #000;
        }
        
        .table-dark th {
            background-color: #e9ecef;
            color: #000;
            font-weight: bold;
            text-align: center;
        }
        
        .table-success {
            background-color: #d4edda;
        }
        
        .table-danger {
            background-color: #f8d7da;
        }
        
        .table-secondary {
            background-color: #e2e3e5;
        }
        
        .text-success {
            color: #155724;
        }
        
        .text-danger {
            color: #721c24;
        }
        
        .text-info {
            color: #0c5460;
        }
        
        .text-secondary {
            color: #383d41;
        }
        
        .text-muted {
            color: #6c757d;
        }
        
        .badge {
            font-size: 10px;
            padding: 4px 8px;
        }
        
        .bg-primary {
            background-color: #007bff;
            color: white;
        }
        
        .bg-info {
            background-color: #17a2b8;
            color: white;
        }
        
        .bg-success {
            background-color: #28a745;
            color: white;
        }
        
        .bg-warning {
            background-color: #ffc107;
            color: #212529;
        }
        
        .bg-secondary {
            background-color: #6c757d;
            color: white;
        }
        
        .bg-light {
            background-color: #f8f9fa;
            color: #212529;
        }
        
        .btn {
            display: none;
        }
        
        .fas {
            display: inline-block;
        }
        
        .fa-check, .fa-times, .fa-list, .fa-file-text {
            display: inline-block;
        }
        
        .fa-check:before {
            content: "✓";
        }
        
        .fa-times:before {
            content: "✗";
        }
        
        .fa-list:before {
            content: "📋";
        }
        
        .fa-file-text:before {
            content: "📄";
        }
        
        .page-break {
            page-break-before: always;
        }
        
        @page {
            size: A4;
            margin: 0.5in;
        }
        
        .table-borderless {
            border: none;
        }
        
        .table-borderless td {
            border: none;
            padding: 2px 8px;
        }
        
        .fw-bold {
            font-weight: bold;
        }
        
        .mb-4 {
            margin-bottom: 20px;
        }
        
        .mb-0 {
            margin-bottom: 0;
        }
        
        .me-2 {
            margin-right: 8px;
        }
        
        .d-flex {
            display: flex;
        }
        
        .align-items-center {
            align-items: center;
        }
        
        .text-center {
            text-align: center;
        }
        
        .border-primary {
            border: 1px solid #007bff;
        }
        
        .border-info {
            border: 1px solid #17a2b8;
        }
        
        .rounded {
            border-radius: 4px;
        }
        
        .img-fluid {
            max-width: 100%;
            height: auto;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            รายงานผลการประเมินผลิตภัณฑ์
                        </h4>
                    </div>
                    <div class="card-body">
                        <!-- บล็อกแสดงข้อมูลผลิตภัณฑ์ -->
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <div class="card border-primary">
                                    <div class="card-header bg-primary text-white">
                                        <h5 class="mb-0">
                                            ข้อมูลผลิตภัณฑ์
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-borderless">
                                                    <tr>
                                                        <td class="fw-bold" style="width: 150px;">ชื่อผลิตภัณฑ์:</td>
                                                        <td>{{ $product->name ?? 'ไม่ระบุ' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="fw-bold">โมเดล/รุ่น:</td>
                                                        <td>{{ $product->model ?? 'ไม่ระบุ' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="fw-bold">วิธีรับข้อมูล:</td>
                                                        <td>{{ $product->log_receive_method ?? 'ไม่ระบุ' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="fw-bold">ประเภทผลิตภัณฑ์:</td>
                                                        <td>{{ $product->product_type ?? 'ไม่ระบุ' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="fw-bold">Email ติดต่อ:</td>
                                                        <td>{{ $product->user->Email ?? 'ไม่ระบุ' }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="col-md-6">
                                                @if($product->image)
                                                    <div class="text-center">
                                                        <img src="{{ asset('storage/' . $product->image) }}" 
                                                             alt="รูปภาพผลิตภัณฑ์" 
                                                             class="img-fluid rounded" 
                                                             style="max-height: 150px;">
                                                    </div>
                                                @else
                                                    <div class="text-center text-muted">
                                                        <p>ไม่มีรูปภาพ</p>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- บล็อกอธิบายความหมายของเครื่องหมาย -->
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <div class="card border-info">
                                    <div class="card-header bg-info text-white">
                                        <h5 class="mb-0">
                                            หมายเหตุ
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="d-flex align-items-center mb-2">
                                                    <span class="text-success me-2">
                                                        ✓
                                                    </span>
                                                    <span class="text-muted">= สอดคล้อง</span>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="d-flex align-items-center mb-2">
                                                    <span class="text-danger me-2">
                                                        ✗
                                                    </span>
                                                    <span class="text-muted">= ไม่สอดคล้อง</span>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="d-flex align-items-center mb-2">
                                                    <span class="text-muted me-2">N/A</span>
                                                    <span class="text-muted">= ไม่เกี่ยวข้องกับการประเมิน</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- ตารางแสดงผลการประเมิน -->
                        <div class="card border-success">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0">
                                    ตารางแสดงผลการประเมิน
                                </h5>
                            </div>
                            <div class="card-body">
                                @if(isset($assessment) && $assessment)
                                    @if($assessment->status === 'draft')
                                        <div class="text-center text-muted py-5">
                                            <h5>ยังเป็นฉบับร่าง</h5>
                                            <p>การประเมินนี้ยังเป็นฉบับร่าง กรุณาส่งการประเมินก่อนเพื่อดูผลการประเมิน</p>
                                        </div>
                                    @else
                                        <div class="mb-4">
                                            <h6 class="text-primary mb-3">
                                                การประเมินวันที่: {{ $assessment->DtmIns->format('d/m/Y H:i') }}
                                            </h6>
                                            
                                            <div class="table-responsive">
                                                <table class="table table-bordered table-hover">
                                                    <thead class="table-dark">
                                                        <tr>
                                                            <th style="width: 80px;" class="text-center">ข้อ</th>
                                                            <th style="width: 300px;" class="text-center">ข้อกำหนด</th>
                                                            <th style="width: 200px;" class="text-center">คำตอบ</th>
                                                            <th style="width: 120px;" class="text-center">ผลการตรวจสอบ</th>
                                                            <th style="width: 300px;" class="text-center">คำอธิบาย</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if(isset($answeredQuestions) && $answeredQuestions->count() > 0)
                                                            @php
                                                                $questionNumber = 1;
                                                            @endphp
                                                            
                                                            @foreach($answeredQuestions as $question)
                                                                @php
                                                                    $answer = $question->answer;
                                                                    $rowClass = '';
                                                                    if ($question->question_type == 'yes_no' && $question->use_in_evaluation) {
                                                                        if ($answer && $answer->answer_text == 'ใช่') {
                                                                            $rowClass = 'table-success';
                                                                        } elseif ($answer && $answer->answer_text == 'ไม่ใช่') {
                                                                            $rowClass = 'table-danger';
                                                                        }
                                                                    } elseif ($question->question_type === null && $question->use_in_evaluation) {
                                                                        if ($answer && $answer->answer_text == 'ใช่') {
                                                                            $rowClass = 'table-success';
                                                                        } elseif ($answer && $answer->answer_text == 'ไม่ใช่') {
                                                                            $rowClass = 'table-danger';
                                                                        }
                                                                    } elseif ($question->question_type == 'multiple_choice' || $question->question_type == 'text') {
                                                                        $rowClass = 'table-secondary';
                                                                    }
                                                                @endphp
                                                                <tr class="{{ $rowClass }}">
                                                                    <td class="text-center fw-bold">
                                                                        @if($question->has_question_number)
                                                                        @php
                                                                            $questionNumber = $question->question_number_only;
                                                                            $level = substr_count($questionNumber, '.');
                                                                            $indent = $level * 20;
                                                                        @endphp
                                                                        <div style="padding-left: {{ $indent }}px; text-align: left;">
                                                                            {{ $questionNumber }}
                                                                        </div>
                                                                        @else
                                                                        {{ $questionNumber }}
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        <strong>{{ $question->question_content ?? $question->question_text ?? 'ไม่ระบุ' }}</strong>
                                                                        @if($question->question_type === null && $question->logic_operator && (strtolower(Auth::user()->Level) === 'admin' || strtolower(Auth::user()->Level) === 'superadmin'))
                                                                            <br><small class="text-muted">(Logic: {{ $question->logic_operator }})</small>
                                                                        @endif
                                                                        @if($question->question_type == 'multiple_choice')
                                                                            <br><small class="text-muted">(คำถามแบบตัวเลือก)</small>
                                                                        @elseif($question->question_type == 'text')
                                                                            <br><small class="text-muted">(คำถามแบบข้อความ)</small>
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        @if($question->question_type === null)
                                                                            -
                                                                        @elseif($answer)
                                                                            @if($question->question_type == 'yes_no')
                                                                                @if($answer->comment)
                                                                                    {{ $answer->comment }}
                                                                                @else
                                                                                    -
                                                                                @endif
                                                                            @elseif($question->question_type == 'multiple_choice')
                                                                                <span class="badge bg-info text-wrap">
                                                                                    {{ $answer->answer_text }}
                                                                                </span>
                                                                            @elseif($question->question_type == 'text')
                                                                                <span class="badge bg-secondary">
                                                                                    ข้อความ
                                                                                </span>
                                                                                <div class="small text-muted mt-1">
                                                                                    {{ Str::limit($answer->answer_text, 100) }}
                                                                                </div>
                                                                            @else
                                                                                <span class="badge bg-secondary">
                                                                                    {{ $answer->answer_text ?? 'ไม่ระบุ' }}
                                                                                </span>
                                                                            @endif
                                                                        @else
                                                                            <span class="text-muted">-</span>
                                                                        @endif
                                                                    </td>
                                                                    <td class="text-center">
                                                                        @if($question->question_type == 'yes_no')
                                                                            @if($question->use_in_evaluation)
                                                                                @if($answer && $answer->answer_text == 'ใช่')
                                                                                    <span class="text-success">
                                                                                        ✓
                                                                                    </span>
                                                                                @elseif($answer && $answer->answer_text == 'ไม่ใช่')
                                                                                    <span class="text-danger">
                                                                                        ✗
                                                                                    </span>
                                                                                @else
                                                                                    <span class="text-muted">N/A</span>
                                                                                @endif
                                                                            @else
                                                                                <span class="text-muted">N/A</span>
                                                                            @endif
                                                                        @elseif($question->question_type === null)
                                                                            @if($question->use_in_evaluation)
                                                                                @if($answer && $answer->answer_text == 'ใช่')
                                                                                    <span class="text-success">
                                                                                        ✓
                                                                                    </span>
                                                                                @elseif($answer && $answer->answer_text == 'ไม่ใช่')
                                                                                    <span class="text-danger">
                                                                                        ✗
                                                                                    </span>
                                                                                @else
                                                                                    <span class="text-muted">N/A</span>
                                                                                @endif
                                                                            @else
                                                                                <span class="text-muted">N/A</span>
                                                                            @endif
                                                                        @elseif($question->question_type == 'multiple_choice')
                                                                            <span class="text-muted">N/A</span>
                                                                        @elseif($question->question_type == 'text')
                                                                            <span class="text-muted">N/A</span>
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        @if($question->description)
                                                                            {{ $question->description }}
                                                                        @else
                                                                            <span class="text-muted">-</span>
                                                                        @endif
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        @else
                                                            <tr>
                                                                <td colspan="5" class="text-center text-muted">
                                                                    ไม่มีคำถามที่ตอบใน Assessment นี้
                                                                </td>
                                                            </tr>
                                                        @endif
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    @endif
                                @else
                                    <div class="text-center text-muted py-5">
                                        <h5>ยังไม่มีข้อมูลการประเมิน</h5>
                                        <p>ไม่พบผลการประเมินสำหรับผลิตภัณฑ์นี้</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html> 