<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('question_groups', function (Blueprint $table) {
            $table->id();

            $table->string('name');  
            $table->string('type')->default('manual');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade'); // foreignId('created_by') จะสร้างคอลัมน์ชื่อ created_by_id และเชื่อมต่อกับตาราง users โดยที่ถ้า user ถูกลบ จะทำการลบข้อมูลทั้งหมดที่เกี่ยวข้องกับ user นั้น
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('question_groups');
    }
};
