<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // เพิ่ม comment ให้คอลัมภ์ที่ยังไม่มี comment
        DB::statement("ALTER TABLE products MODIFY COLUMN id BIGINT UNSIGNED AUTO_INCREMENT COMMENT 'รหัสผลิตภัณฑ์'");
        DB::statement("ALTER TABLE products MODIFY COLUMN user_id INT UNSIGNED COMMENT 'รหัสผู้ใช้เจ้าของผลิตภัณฑ์'");
        DB::statement("ALTER TABLE products MODIFY COLUMN name VARCHAR(255) COMMENT 'ชื่อผลิตภัณฑ์'");
        DB::statement("ALTER TABLE products MODIFY COLUMN model VARCHAR(255) COMMENT 'รุ่นของผลิตภัณฑ์'");
        DB::statement("ALTER TABLE products MODIFY COLUMN log_receive_method ENUM('syslog_udp', 'syslog_tcp', 'syslog_both', 'other') COMMENT 'วิธีการรับข้อมูล(syslog_udp=UDP, syslog_tcp=TCP, syslog_both=ทั้งสอง, other=อื่นๆ)'");
        DB::statement("ALTER TABLE products MODIFY COLUMN product_type ENUM('hw_sw_log_server', 'sw_log_server') COMMENT 'ประเภทผลิตภัณฑ์ (hw_sw_log_server=Hardware+Software, sw_log_server=Software เท่านั้น)'");
        DB::statement("ALTER TABLE products MODIFY COLUMN description TEXT COMMENT 'รายละเอียดผลิตภัณฑ์'");
        DB::statement("ALTER TABLE products MODIFY COLUMN image VARCHAR(255) COMMENT 'รูปภาพผลิตภัณฑ์'");
        DB::statement("ALTER TABLE products MODIFY COLUMN DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'วันที่และเวลาที่สร้างข้อมูล'");
        DB::statement("ALTER TABLE products MODIFY COLUMN DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'วันที่และเวลาที่แก้ไขข้อมูล'");

        // จัดการคอลัมภ์ที่มี Foreign Key Constraint
        // ลบ Foreign Key ก่อน
        DB::statement("ALTER TABLE products DROP FOREIGN KEY products_cusins_id_foreign");
        DB::statement("ALTER TABLE products DROP FOREIGN KEY products_cusudp_id_foreign");
        
        // เพิ่ม comment ให้คอลัมภ์ที่มี Foreign Key
        DB::statement("ALTER TABLE products MODIFY COLUMN CusIns_ID INT UNSIGNED COMMENT 'รหัสลูกค้าที่สร้างข้อมูล'");
        DB::statement("ALTER TABLE products MODIFY COLUMN CusUdp_ID INT UNSIGNED COMMENT 'รหัสลูกค้าที่แก้ไขข้อมูล'");
        
        // เพิ่ม Foreign Key กลับมา
        DB::statement("ALTER TABLE products ADD CONSTRAINT products_cusins_id_foreign FOREIGN KEY (CusIns_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE products ADD CONSTRAINT products_cusudp_id_foreign FOREIGN KEY (CusUdp_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // ลบ Foreign Key ก่อน
        DB::statement("ALTER TABLE products DROP FOREIGN KEY products_cusins_id_foreign");
        DB::statement("ALTER TABLE products DROP FOREIGN KEY products_cusudp_id_foreign");
        
        // ลบ comment โดยไม่ระบุ comment
        DB::statement("ALTER TABLE products MODIFY COLUMN id BIGINT UNSIGNED AUTO_INCREMENT");
        DB::statement("ALTER TABLE products MODIFY COLUMN user_id INT UNSIGNED");
        DB::statement("ALTER TABLE products MODIFY COLUMN name VARCHAR(255)");
        DB::statement("ALTER TABLE products MODIFY COLUMN model VARCHAR(255)");
        DB::statement("ALTER TABLE products MODIFY COLUMN log_receive_method ENUM('syslog_udp', 'syslog_tcp', 'syslog_both', 'other')");
        DB::statement("ALTER TABLE products MODIFY COLUMN product_type ENUM('hw_sw_log_server', 'sw_log_server')");
        DB::statement("ALTER TABLE products MODIFY COLUMN description TEXT");
        DB::statement("ALTER TABLE products MODIFY COLUMN image VARCHAR(255)");
        DB::statement("ALTER TABLE products MODIFY COLUMN CusIns_ID INT UNSIGNED");
        DB::statement("ALTER TABLE products MODIFY COLUMN CusUdp_ID INT UNSIGNED");
        DB::statement("ALTER TABLE products MODIFY COLUMN DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
        DB::statement("ALTER TABLE products MODIFY COLUMN DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
        
        // เพิ่ม Foreign Key กลับมา
        DB::statement("ALTER TABLE products ADD CONSTRAINT products_cusins_id_foreign FOREIGN KEY (CusIns_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE products ADD CONSTRAINT products_cusudp_id_foreign FOREIGN KEY (CusUdp_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
    }
};
