<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // เปลี่ยนชนิดข้อมูลจาก bigint เป็น int unsigned
            $table->unsignedInteger('Agency_ID')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // เปลี่ยนกลับเป็น bigint
            $table->unsignedBigInteger('Agency_ID')->nullable()->change();
        });
    }
};
