<?php
$content = file_get_contents('app/Http/Controllers/ProductController.php');

// แทนที่บรรทัดที่มีปัญหา
$old_line = "            \$agencies = \$user->agencies()->where('active', 1)->sortBy('Agency_Name');";
$new_line = "            // ดึงรายการบริษัทผ่าน AgencyCustomer model
            \$agencyCustomerIds = AgencyCustomer::where('Customer_ID', \$user->Customer_ID)->pluck('Agency_ID');
            \$agencies = Agency::whereIn('Agency_ID', \$agencyCustomerIds)
                ->where('active', 1)
                ->orderBy('Agency_Name')
                ->get();";

$content = str_replace($old_line, $new_line, $content);

file_put_contents('app/Http/Controllers/ProductController.php', $content);
echo "Fixed ProductController agencies query\n";
?>
