@extends('layouts.app')

@section('content')
<div class="container mt-4">
  <div class="row justify-content-center">
    <div class="col-md-8">
      <!-- Progress Bar -->
      <div class="card shadow mb-4">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <h6 class="mb-0">
              <i class="fas fa-edit me-2"></i>
              ทำต่อการประเมินผลิตภัณฑ์
            </h6>
            <span id="progress-text" class="badge bg-warning">ฉบับร่าง</span>
          </div>
          <div class="progress" style="height: 10px;">
            <div id="progress-bar" class="progress-bar bg-warning" role="progressbar" style="width: 0%"></div>
          </div>
          <div id="progress-status" class="text-muted small mt-2">
            กรุณาตอบคำถามการประเมินให้ครบถ้วน
          </div>
        </div>
      </div>

      <!-- แสดงข้อมูลผลิตภัณฑ์ -->
      <div class="card shadow mb-4">
        <div class="card-header bg-info text-white">
          <h4 class="mb-0">
            <i class="fas fa-box me-2"></i>
            ข้อมูลผลิตภัณฑ์
          </h4>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <table class="table table-borderless">
                <tr>
                  <td class="fw-bold" style="width: 150px;">ชื่อผลิตภัณฑ์:</td>
                  <td>{{ $assessment->product->name ?? 'ไม่ระบุ' }}</td>
                </tr>
                <tr>
                  <td class="fw-bold">โมเดล/รุ่น:</td>
                  <td>{{ $assessment->product->model ?? 'ไม่ระบุ' }}</td>
                </tr>
                <tr>
                  <td class="fw-bold">วิธีรับข้อมูล:</td>
                  <td>{{ $assessment->product->log_receive_method ?? 'ไม่ระบุ' }}</td>
                </tr>
                <tr>
                  <td class="fw-bold">ประเภทผลิตภัณฑ์:</td>
                  <td>{{ $assessment->product->product_type ?? 'ไม่ระบุ' }}</td>
                </tr>
              </table>
            </div>
            <div class="col-md-6">
              @if($assessment->product->image)
                <div class="text-center">
                  <img src="{{ asset('storage/' . $assessment->product->image) }}" 
                       alt="รูปภาพผลิตภัณฑ์" 
                       class="img-fluid rounded" 
                       style="max-height: 150px;">
                </div>
              @else
                <div class="text-center text-muted">
                  <i class="fas fa-image fa-2x mb-2"></i>
                  <p>ไม่มีรูปภาพ</p>
                </div>
              @endif
            </div>
          </div>
        </div>
      </div>

      <!-- คำแนะนำ -->
      <div class="alert alert-warning border-0 shadow-sm">
        <div class="d-flex align-items-center">
          <i class="fas fa-exclamation-triangle fa-2x me-3 text-warning"></i>
          <div>
            <h6 class="alert-heading mb-1">ทำต่อจากฉบับร่าง</h6>
            <p class="mb-0 small">คุณสามารถทำต่อการประเมินจากที่ค้างไว้ และส่งแบบประเมินเมื่อพร้อม</p>
          </div>
        </div>
      </div>

      <form method="POST" action="{{ route('assessments.update', $assessment) }}" id="assessment-form">
        @csrf
        @method('PUT')

        <!-- แสดงคำถามโดยตรง -->
        <div class="mb-4">
          @php
            $globalQuestionNumber = 1;
          @endphp
          @foreach($questionGroups as $groupIndex => $group)
          <div class="mb-4">
            <div class="row">
              @foreach($group->questions as $questionIndex => $question)
              @if($question->use_in_evaluation && !$question->parent_id && $question->question_type !== null)
              <!-- คำถามปกติที่ใช้ในการประเมิน (ไม่มี parent และ question_type ไม่เป็น null) -->
              <div class="col-12 mb-4">
                <div class="card border-0 shadow-sm">
                  <div class="card-body p-4">
                    <div class="d-flex align-items-start mb-3">
                      <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; min-width: 40px;">
                        <span class="question-number">{{ $globalQuestionNumber }}</span>
                      </div>
                      <div class="flex-grow-1">
                        <h6 class="card-title mb-2 question-label">{{ $question->question_text }}</h6>
                        <!-- ฟอร์มตอบคำถาม -->
                        @if($question->question_type == 'yes_no')
                          <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                          <div class="mb-3">
                            @php
                              $existingAnswer = $assessment->answers->where('question_id', $question->id)->first();
                              $existingChoice = $existingAnswer ? $existingAnswer->answer_text : null;
                              $existingDetails = $existingAnswer ? $existingAnswer->comment : null;
                            @endphp
                            <div class="form-check form-check-inline">
                              <input class="form-check-input yes-no-radio" type="radio" 
                                     name="answers[{{ $question->id }}][choice]" 
                                     id="yes_{{ $question->id }}" 
                                     value="yes" 
                                     data-question-id="{{ $question->id }}"
                                     {{ $existingChoice == 'ใช่' ? 'checked' : '' }}>
                              <label class="form-check-label" for="yes_{{ $question->id }}">
                                ใช่
                              </label>
                            </div>
                            <div class="form-check form-check-inline">
                              <input class="form-check-input yes-no-radio" type="radio" 
                                     name="answers[{{ $question->id }}][choice]" 
                                     id="no_{{ $question->id }}" 
                                     value="no" 
                                     data-question-id="{{ $question->id }}"
                                     {{ $existingChoice == 'ไม่ใช่' ? 'checked' : '' }}>
                              <label class="form-check-label" for="no_{{ $question->id }}">
                                ไม่ใช่
                              </label>
                            </div>
                          </div>
                          <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                          <div id="text_field_{{ $question->id }}" class="mt-3" style="display: {{ $existingChoice == 'ใช่' ? 'block' : 'none' }};">
                            <label class="form-label text-muted">
                              <i class="fas fa-comment me-1"></i>
                              กรุณาระบุรายละเอียดเพิ่มเติม:
                            </label>
                            <textarea
                              name="answers[{{ $question->id }}][details]"
                              class="form-control border-0 bg-light evaluation-field"
                              rows="3"
                              placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                              style="resize: none;"
                              data-field="evaluation_{{ $question->id }}_details">{{ $existingDetails }}</textarea>
                          </div>
                        @elseif($question->question_type == 'multiple_choice')
                          <!-- สำหรับคำถามแบบตัวเลือก -->
                          <div class="mb-3">
                            @php
                              $choices = $question->choices;
                              if (is_string($choices)) {
                                  $choices = json_decode($choices, true);
                              }
                              $existingAnswer = $assessment->answers->where('question_id', $question->id)->first();
                              $existingChoice = $existingAnswer ? $existingAnswer->answer_text : null;
                            @endphp
                            @if($choices && is_array($choices) && count($choices) > 0)
                              @foreach($choices as $choiceIndex => $choice)
                                <div class="form-check">
                                  <input class="form-check-input multiple-choice-radio" type="radio"
                                    name="answers[{{ $question->id }}][choice]"
                                    id="choice_{{ $question->id }}_{{ $choiceIndex }}"
                                    value="{{ $choice }}"
                                    data-question-id="{{ $question->id }}"
                                    {{ $existingChoice == $choice ? 'checked' : '' }}>
                                  <label class="form-check-label" for="choice_{{ $question->id }}_{{ $choiceIndex }}">
                                    {{ $choice }}
                                  </label>
                                </div>
                              @endforeach
                            @else
                              <div class="alert alert-warning border-0">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                              </div>
                            @endif
                          </div>
                        @elseif($question->question_type == 'text')
                          <!-- สำหรับคำถามแบบข้อความ -->
                          <div class="mb-3">
                            @php
                              $existingAnswer = $assessment->answers->where('question_id', $question->id)->first();
                              $existingText = $existingAnswer ? $existingAnswer->answer_text : '';
                            @endphp
                            <textarea
                              name="answers[{{ $question->id }}][text]"
                              class="form-control border-0 bg-light evaluation-field"
                              rows="3"
                              placeholder="กรุณาตอบคำถาม..."
                              style="resize: none;"
                              data-field="evaluation_{{ $question->id }}_text">{{ $existingText }}</textarea>
                          </div>
                        @endif
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              @php $globalQuestionNumber++; @endphp
              @elseif(!$question->use_in_evaluation && $question->question_type === null && !$question->parent_id)
              <!-- Parent Question (ระดับ 1) - แสดงเป็น accordion button เสมอ -->
              <div class="col-12 mb-3">
                <div class="accordion-item border-0">
                  <h2 class="accordion-header" id="heading-parent-{{ $question->id }}">
                    <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-parent-{{ $question->id }}" style="padding: 1.5rem;">
                      <div class="d-flex align-items-center w-100">
                        <div class="flex-grow-1">
                          <h6 class="mb-1 question-label">{{ $question->question_text }}</h6>
                          <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                        </div>
                        <i class="fas fa-chevron-down ms-auto"></i>
                      </div>
                    </button>
                  </h2>
                  <div id="collapse-parent-{{ $question->id }}" class="accordion-collapse collapse" aria-labelledby="heading-parent-{{ $question->id }}">
                    <div class="accordion-body bg-white p-4">
                      <div class="row">
                        @foreach($group->questions->where('parent_id', $question->id) as $childIndex => $child)
                        @if($child->use_in_evaluation && $child->question_type !== null)
                        <!-- Child Questions ที่ใช้ในการประเมินและ question_type ไม่เป็น null -->
                        <div class="col-12 mb-4">
                          <div class="card border-0 shadow-sm">
                            <div class="card-body p-4">
                              <div class="ms-4 border-start border-primary ps-3">
                                <div class="d-flex align-items-start mb-3">
                                  <div class="flex-grow-1">
                                    <h6 class="card-title mb-2 text-dark">{{ $child->question_text }}</h6>
                                    <!-- ฟอร์มตอบคำถาม -->
                                    @if($child->question_type == 'yes_no')
                                      <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                      <div class="mb-3">
                                        @php
                                          $existingAnswer = $assessment->answers->where('question_id', $child->id)->first();
                                          $existingChoice = $existingAnswer ? $existingAnswer->answer_text : null;
                                          $existingDetails = $existingAnswer ? $existingAnswer->comment : null;
                                        @endphp
                                        <div class="form-check form-check-inline">
                                          <input class="form-check-input yes-no-radio" type="radio"
                                            name="answers[{{ $child->id }}][choice]"
                                            id="yes_{{ $child->id }}"
                                            value="yes"
                                            data-question-id="{{ $child->id }}"
                                            {{ $existingChoice == 'ใช่' ? 'checked' : '' }}>
                                          <label class="form-check-label" for="yes_{{ $child->id }}">
                                            ใช่
                                          </label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                          <input class="form-check-input yes-no-radio" type="radio"
                                            name="answers[{{ $child->id }}][choice]"
                                            id="no_{{ $child->id }}"
                                            value="no"
                                            data-question-id="{{ $child->id }}"
                                            {{ $existingChoice == 'ไม่ใช่' ? 'checked' : '' }}>
                                          <label class="form-check-label" for="no_{{ $child->id }}">
                                            ไม่ใช่
                                          </label>
                                        </div>
                                      </div>
                                      <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                      <div id="text_field_{{ $child->id }}" class="mt-3" style="display: {{ $existingChoice == 'ใช่' ? 'block' : 'none' }};">
                                        <label class="form-label text-muted">
                                          <i class="fas fa-comment me-1"></i>
                                          กรุณาระบุรายละเอียดเพิ่มเติม:
                                        </label>
                                        <textarea
                                          name="answers[{{ $child->id }}][details]"
                                          class="form-control border-0 bg-light evaluation-field"
                                          rows="3"
                                          placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                          style="resize: none;"
                                          data-field="evaluation_{{ $child->id }}_details">{{ $existingDetails }}</textarea>
                                      </div>
                                    @elseif($child->question_type == 'multiple_choice')
                                      <!-- สำหรับคำถามแบบตัวเลือก -->
                                      <div class="mb-3">
                                        @php
                                          $choices = $child->choices;
                                          if (is_string($choices)) {
                                              $choices = json_decode($choices, true);
                                          }
                                          $existingAnswer = $assessment->answers->where('question_id', $child->id)->first();
                                          $existingChoice = $existingAnswer ? $existingAnswer->answer_text : null;
                                        @endphp
                                        @if($choices && is_array($choices) && count($choices) > 0)
                                          @foreach($choices as $choiceIndex => $choice)
                                            <div class="form-check">
                                              <input class="form-check-input multiple-choice-radio" type="radio"
                                                name="answers[{{ $child->id }}][choice]"
                                                id="choice_{{ $child->id }}_{{ $choiceIndex }}"
                                                value="{{ $choice }}"
                                                data-question-id="{{ $child->id }}"
                                                {{ $existingChoice == $choice ? 'checked' : '' }}>
                                              <label class="form-check-label" for="choice_{{ $child->id }}_{{ $choiceIndex }}">
                                                {{ $choice }}
                                              </label>
                                            </div>
                                          @endforeach
                                        @else
                                          <div class="alert alert-warning border-0">
                                            <i class="fas fa-exclamation-triangle me-2"></i>
                                            ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                          </div>
                                        @endif
                                      </div>
                                    @elseif($child->question_type == 'text')
                                      <!-- สำหรับคำถามแบบข้อความ -->
                                      <div class="mb-3">
                                        @php
                                          $existingAnswer = $assessment->answers->where('question_id', $child->id)->first();
                                          $existingText = $existingAnswer ? $existingAnswer->answer_text : '';
                                        @endphp
                                        <textarea
                                          name="answers[{{ $child->id }}][text]"
                                          class="form-control border-0 bg-light evaluation-field"
                                          rows="3"
                                          placeholder="กรุณาตอบคำถาม..."
                                          style="resize: none;"
                                          data-field="evaluation_{{ $child->id }}_text">{{ $existingText }}</textarea>
                                      </div>
                                    @endif
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        @php $globalQuestionNumber++; @endphp
                        @endif
                        @endforeach
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              @endif
              @endforeach
            </div>
          </div>
          @endforeach
        </div>

        <!-- ปุ่มส่งแบบฟอร์ม -->
        <div class="text-center mt-4">
          <div class="d-flex justify-content-center gap-3">
            <button type="button" class="btn btn-secondary btn-lg px-4" onclick="history.back()">
              <i class="fas fa-arrow-left me-2"></i>
              ย้อนกลับ
            </button>
            <button type="submit" class="btn btn-success btn-lg px-5" id="evaluation-submit-btn" style="display: none;">
              <i class="fas fa-paper-plane me-2"></i>
              ส่งแบบประเมิน
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const evaluationFields = document.querySelectorAll('.evaluation-field');
    const progressBar = document.getElementById('progress-bar');
    const progressText = document.getElementById('progress-text');
    const progressStatus = document.getElementById('progress-status');
    const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');

    // นับจำนวนคำถามทั้งหมดที่ต้องตอบ
    const questionIds = new Set();
    const selectedRadios = document.querySelectorAll('.yes-no-radio');
    selectedRadios.forEach(radio => {
      questionIds.add(radio.getAttribute('data-question-id'));
    });

    const totalFields = questionIds.size;
    let completedFields = 0;

    // ฟังก์ชันตรวจสอบว่าฟิลด์มีข้อมูลหรือไม่
    function isFieldFilled(field) {
      if (field.type === 'file') {
        return field.files.length > 0;
      } else if (field.tagName === 'SELECT') {
        return field.value !== '';
      } else {
        return field.value.trim() !== '';
      }
    }

    // ฟังก์ชันอัปเดต progress
    function updateProgress() {
      completedFields = 0;
      const answeredQuestions = new Set();
      
      // นับ radio buttons ที่เลือกแล้ว (yes_no เท่านั้น)
      const selectedRadios = document.querySelectorAll('.yes-no-radio:checked');
      selectedRadios.forEach(radio => {
        answeredQuestions.add(radio.getAttribute('data-question-id'));
      });
      
      completedFields = answeredQuestions.size;
      
      const percentage = totalFields > 0 ? (completedFields / totalFields) * 100 : 0;

      // อัปเดต progress bar
      progressBar.style.width = percentage + '%';

      // อัปเดตข้อความและปุ่ม
      if (completedFields === totalFields && totalFields > 0) {
        progressText.textContent = 'Complete!';
        progressText.className = 'badge bg-success';
        progressStatus.textContent = 'พร้อมส่งแบบประเมิน';
        
        // แสดงปุ่มส่งแบบประเมิน
        const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');
        if (evaluationSubmitBtn) {
          evaluationSubmitBtn.style.display = 'inline-block';
          evaluationSubmitBtn.disabled = false;
        }
      } else {
        progressText.textContent = `${completedFields}/${totalFields}`;
        progressText.className = 'badge bg-warning';
        progressStatus.textContent = `กรุณาตอบคำถามให้ครบถ้วน (${completedFields}/${totalFields})`;
        
        // ซ่อนปุ่มส่งแบบประเมิน
        const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');
        if (evaluationSubmitBtn) {
          evaluationSubmitBtn.style.display = 'none';
        }
      }
    }

    // เพิ่ม event listeners สำหรับ radio buttons
    const radioButtons = document.querySelectorAll('.yes-no-radio');
    radioButtons.forEach(radio => {
      radio.addEventListener('change', function() {
        const questionId = this.getAttribute('data-question-id');
        const textField = document.getElementById(`text_field_${questionId}`);
        
        if (this.value === 'yes') {
          if (textField) {
            textField.style.display = 'block';
          }
        } else {
          if (textField) {
            textField.style.display = 'none';
            // ล้างค่าใน textarea
            const textarea = textField.querySelector('textarea');
            if (textarea) {
              textarea.value = '';
            }
          }
        }
        
        updateProgress();
      });
    });

    // เพิ่ม event listeners สำหรับ text fields
    evaluationFields.forEach(field => {
      field.addEventListener('input', updateProgress);
    });

    // อัปเดต progress ครั้งแรก
    updateProgress();
    
    // ตรวจสอบสถานะเริ่มต้น
    const initialSelectedRadios = document.querySelectorAll('.yes-no-radio:checked');
    const initialCompletedFields = initialSelectedRadios.length;
    
    if (initialCompletedFields === totalFields && totalFields > 0) {
      // ถ้าตอบครบแล้วตั้งแต่เริ่มต้น ให้แสดงปุ่มส่งแบบประเมิน
      const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');
      if (evaluationSubmitBtn) {
        evaluationSubmitBtn.style.display = 'inline-block';
        evaluationSubmitBtn.disabled = false;
      }
    }
  });
</script>
@endsection 