<section>
    <header class="mb-4">
        <h2 class="h5 text-gray-900">
            {{ __('ข้อมูลส่วนตัว') }}
        </h2>

        <p class="text-muted small">
            {{ __("อัพเดทข้อมูลส่วนตัว และอีเมลสำหรับบัญชีของคุณ") }}
        </p>
    </header>

    <form id="send-verification" method="post" action="{{ route('verification.send') }}">
        @csrf
    </form>

    <form method="post" action="{{ route('profile.update') }}">
        @csrf
        @method('patch')

        <div class="mb-3">
            <label for="name" class="form-label">{{ __('ชื่อ') }}</label>
            <input id="name" name="name" type="text" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $user->name) }}" required autofocus autocomplete="name">
            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="email" class="form-label">{{ __('อีเมล') }}</label>
            <input id="email" name="email" type="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $user->email) }}" required autocomplete="username">
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror

            @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                <div class="mt-2">
                    <p class="text-muted small">
                        {{ __('อีเมลของคุณยังไม่ได้ยืนยัน') }}

                        <button form="send-verification" class="btn btn-link btn-sm p-0 text-decoration-none">
                            {{ __('กรุณากดปุ่มนี้เพื่อส่งอีเมลยืนยันอีเมลอีกครั้ง') }}
                        </button>
                    </p>

                    @if (session('status') === 'verification-link-sent')
                        <p class="text-success small">
                            {{ __('A new verification link has been sent to your email address.') }}
                        </p>
                    @endif
                </div>
            @endif
        </div>

        <div class="d-flex align-items-center gap-3">
            <button type="submit" class="btn btn-primary">{{ __('บันทึก') }}</button>

            @if (session('status') === 'profile-updated')
                <p class="text-muted small mb-0">{{ __('บันทึกเรียบร้อย') }}</p>
            @endif
        </div>
    </form>
</section>
