<?php
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProductController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AssessmentController;
use App\Http\Controllers\SsoController;

Route::get('/', function () {
    return view('auth.login');
});

// ---- SSO (อยู่นอก auth middleware) ----
Route::get('/sso/login', [SsoController::class, 'login'])->name('sso.login');
Route::get('/dashboard', [ProductController::class, 'index'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware(['auth', 'check.user.status'])->group(function () {
    //nav
    // Route::get('/login')
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    // Product
    Route::get('/products', [ProductController::class, 'index'])->name('products.index');//เบราว์เซอร์จะส่งคำขอไปที่ ProductController ที่มีชื่อว่า index
    Route::get('/products/create', [ProductController::class, 'create'])->name('products.create');//เบราว์เซอร์จะส่งคำขอไปที่ ProductController ที่มีชื่อว่า create
    Route::get('/products/create-new', [ProductController::class, 'createNew'])->name('products.create-new');//เริ่มต้นเพิ่มผลิตภัณฑ์ใหม่ (ล้าง session)
    Route::post('/products' , [ProductController::class, 'store'])->name('products.store');//เบราว์จะส่งข้อมูลไปที่ ProductController ที่มีชื่อว่า store
    Route::post('/products/back-to-edit', [ProductController::class, 'backToEdit'])->name('products.back-to-edit');//ย้อนกลับไปแก้ไขข้อมูลผลิตภัณฑ์
    Route::delete('/products/{product}', [ProductController::class, 'destroy'])->name('products.destroy');//ลบข้อมูลผลิตภัณฑ์
    Route::get('/products/report/{product}', [ProductController::class, 'report'])->name('products.report');//สร้างรายงานผลิตภัณฑ์

    
    // Additional product routes for company and personal filtering
    Route::get('/products/company/{companyId}', [ProductController::class, 'companyProducts'])->name('products.company');
    Route::get('/products/my', [ProductController::class, 'myProducts'])->name('products.my');

    // Assessment
    Route::get('/assessments/create/{product}', [AssessmentController::class, 'create'])->name('assessments.create');//เริ่มการประเมิณ(หน้าออกแบบการประเมิณ)
    Route::post('/assessments', [AssessmentController::class, 'store'])->name('assessments.store');//บันทึกการประเมิณ
    Route::post('/assessments/draft', [AssessmentController::class, 'storeDraft'])->name('assessments.store-draft');//บันทึกฉบับร่าง
    Route::get('/assessments/continue-draft/{product}', [AssessmentController::class, 'continueDraft'])->name('assessments.continue-draft');//ทำต่อจากฉบับร่าง
    Route::post('/assessments/submit-draft', [AssessmentController::class, 'submitDraft'])->name('assessments.submit-draft');//ส่งฉบับร่าง
    Route::get('/assessments/{assessment}/edit', [AssessmentController::class, 'edit'])->name('assessments.edit');//แก้ไขการประเมิณ
    Route::get('/assessments/{assessment}/manual', [AssessmentController::class, 'manual'])->name('assessments.manual');//แบบประเมินคู่มือ
    Route::put('/assessments/{assessment}', [AssessmentController::class, 'update'])->name('assessments.update');//อัปเดตการประเมิณ
});

Route::middleware(['auth', 'admin'])->prefix('admin')->group(function () {
    // Admin Dashboard
    Route::get('/dashboard', [App\Http\Controllers\AdminController::class, 'dashboard'])->name('admin.dashboard');
    
    // Admin Users Management
    Route::get('/users', [App\Http\Controllers\AdminController::class, 'users'])->name('admin.users');
    Route::post('/users/{user}/toggle-status', [App\Http\Controllers\AdminController::class, 'toggleUserStatus'])->name('admin.users.toggle-status');
    
    // Admin Products Management
    Route::get('/products', [App\Http\Controllers\AdminController::class, 'products'])->name('admin.products');
    Route::get('/products/{product}/edit', [App\Http\Controllers\AdminController::class, 'editProduct'])->name('admin.products.edit');
    Route::put('/products/{product}', [App\Http\Controllers\AdminController::class, 'updateProduct'])->name('admin.products.update');
    Route::delete('/products/{product}', [App\Http\Controllers\AdminController::class, 'deleteProduct'])->name('admin.products.delete');
    Route::get('/products/{product}/report', [App\Http\Controllers\AdminController::class, 'viewReport'])->name('admin.products.report');
    
    // Admin Assessments Management
    Route::get('/assessments', [App\Http\Controllers\AdminController::class, 'assessments'])->name('admin.assessments');
    Route::get('/assessments/{assessment}/view', [App\Http\Controllers\AdminController::class, 'viewAssessment'])->name('admin.assessments.view');
    Route::get('/assessments/{assessment}/report', [App\Http\Controllers\AdminController::class, 'assessmentReport'])->name('admin.assessments.report');
    Route::delete('/assessments/{assessment}', [App\Http\Controllers\AdminController::class, 'deleteAssessment'])->name('admin.assessments.delete');
    
    // Admin Reports
    Route::get('/reports', [App\Http\Controllers\AdminController::class, 'reports'])->name('admin.reports');
    
    // Admin Question Groups Management
    Route::get('/question-groups', [App\Http\Controllers\AdminController::class, 'questionGroups'])->name('admin.question-groups');
    Route::get('/question-groups/create', [App\Http\Controllers\AdminController::class, 'createQuestionGroup'])->name('admin.question-groups.create');
    Route::post('/question-groups', [App\Http\Controllers\AdminController::class, 'storeQuestionGroup'])->name('admin.question-groups.store');
    Route::get('/question-groups/{group}/edit', [App\Http\Controllers\AdminController::class, 'editQuestionGroup'])->name('admin.question-groups.edit');
    Route::put('/question-groups/{group}', [App\Http\Controllers\AdminController::class, 'updateQuestionGroup'])->name('admin.question-groups.update');
    Route::delete('/question-groups/{group}', [App\Http\Controllers\AdminController::class, 'deleteQuestionGroup'])->name('admin.question-groups.delete');
    Route::post('/question-groups/{group}/toggle-active', [App\Http\Controllers\AdminController::class, 'toggleQuestionGroupActive'])->name('admin.question-groups.toggle-active');
    
    // Admin Questions Management
    Route::get('/question-groups/{group}/questions/create', [App\Http\Controllers\AdminController::class, 'createQuestion'])->name('admin.questions.create');
    Route::post('/question-groups/{group}/questions', [App\Http\Controllers\AdminController::class, 'storeQuestion'])->name('admin.questions.store');
    Route::get('/questions/{question}/edit', [App\Http\Controllers\AdminController::class, 'editQuestion'])->name('admin.questions.edit');
    Route::put('/questions/{question}', [App\Http\Controllers\AdminController::class, 'updateQuestion'])->name('admin.questions.update');
    Route::delete('/questions/{question}', [App\Http\Controllers\AdminController::class, 'deleteQuestion'])->name('admin.questions.delete');

    // Admin Question Tree Structure with D3.js
    Route::get('/question-groups/{group}/d3-tree-structure', [App\Http\Controllers\AdminController::class, 'showQuestionTreeStructure'])->name('admin.question-groups.d3-tree-structure');

    
    // Admin Question Order Management (Drag & Drop)
    Route::post('/questions/update-order', [App\Http\Controllers\AdminController::class, 'updateQuestionOrder'])->name('admin.questions.update-order');
    
    // Admin Question Move Management
    Route::post('/questions/move', [App\Http\Controllers\AdminController::class, 'moveQuestion'])->name('admin.questions.move');
    
    // Admin Question Logic Management
    Route::post('/questions/{question}/update-logic', [App\Http\Controllers\AdminController::class, 'updateQuestionLogic'])->name('admin.questions.update-logic');

});

// Route สำหรับแสดงข้อมูลคำถามทั้งหมด (สำหรับการวิเคราะห์)
Route::get('/questions/show', function () {
    $questions = \App\Models\Question::with(['questionGroup', 'parent'])
        ->orderBy('question_group_id')
        ->orderBy('sort_order')
        ->get();

    return view('questions.show', compact('questions'));
})->name('questions.show');

require __DIR__.'/auth.php';
